"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, account_id: str, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the access point policy for the specified access point.  All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section. The following actions are related to DeleteAccessPointPolicy:    PutAccessPointPolicy     GetAccessPointPolicy

    Args:
        account_id(str): The account ID for the account that owns the specified access point.
        name(str): The name of the access point whose policy you want to delete. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>. For example, to access the access point reports-ap through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap. The value must be URL encoded. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.init.delete(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.init.delete account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_access_point_policy",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the access point policy associated with the specified access point. The following actions are related to GetAccessPointPolicy:    PutAccessPointPolicy     DeleteAccessPointPolicy

    Args:
        account_id(str): The account ID for the account that owns the specified access point.
        name(str): The name of the access point whose policy you want to retrieve. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>. For example, to access the access point reports-ap through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap. The value must be URL encoded. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.init.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.init.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point_policy",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def put(hub, ctx, account_id: str, name: str, policy: str) -> None:
    r"""
    **Autogenerated function**

    Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.  All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section. The following actions are related to PutAccessPointPolicy:    GetAccessPointPolicy     DeleteAccessPointPolicy

    Args:
        account_id(str): The account ID for owner of the bucket associated with the specified access point.
        name(str): The name of the access point that you want to associate with the specified policy. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>. For example, to access the access point reports-ap through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap. The value must be URL encoded. .
        policy(str): The policy that you want to apply to the specified access point. For more information about access point policies, see Managing data access with Amazon S3 access points in the Amazon S3 User Guide.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.init.put(
                ctx, account_id=value, name=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.init.put account_id=value, name=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_access_point_policy",
        op_kwargs={"AccountId": account_id, "Name": name, "Policy": policy},
    )
