"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "for_object_lambda"


async def delete(hub, ctx, account_id: str, name: str) -> None:
    r"""
    **Autogenerated function**

    Removes the resource policy for an Object Lambda Access Point. The following actions are related to DeleteAccessPointPolicyForObjectLambda:    GetAccessPointPolicyForObjectLambda     PutAccessPointPolicyForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point you want to delete the policy for.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.for_object_lambda_.delete(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.for_object_lambda.delete account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_access_point_policy_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the resource policy for an Object Lambda Access Point. The following actions are related to GetAccessPointPolicyForObjectLambda:    DeleteAccessPointPolicyForObjectLambda     PutAccessPointPolicyForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.for_object_lambda_.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.for_object_lambda.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point_policy_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def put(hub, ctx, account_id: str, name: str, policy: str) -> None:
    r"""
    **Autogenerated function**

    Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see Creating Object Lambda Access Points in the Amazon S3 User Guide. The following actions are related to PutAccessPointPolicyForObjectLambda:    DeleteAccessPointPolicyForObjectLambda     GetAccessPointPolicyForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point.
        policy(str): Object Lambda Access Point resource policy document.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.policy.for_object_lambda_.put(
                ctx, account_id=value, name=value, policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.policy.for_object_lambda.put account_id=value, name=value, policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_access_point_policy_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name, "Policy": policy},
    )
