"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    account_id: str,
    name: str,
    bucket: str,
    vpc_configuration: Dict = None,
    public_access_block_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an access point and associates it with the specified bucket. For more information, see Managing Data Access with Amazon S3 Access Points in the Amazon S3 User Guide.   S3 on Outposts only supports VPC-style access points.  For more information, see  Accessing Amazon S3 on Outposts using virtual private cloud (VPC) only access points in the Amazon S3 User Guide.  All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section.  The following actions are related to CreateAccessPoint:    GetAccessPoint     DeleteAccessPoint     ListAccessPoints

    Args:
        account_id(str): The account ID for the owner of the bucket for which you want to create an access point.
        name(str): The name you want to assign to this access point.
        bucket(str): The name of the bucket that you want to associate this access point with. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>. For example, to access the bucket reports through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports. The value must be URL encoded. .
        vpc_configuration(Dict, optional): If you include this field, Amazon S3 restricts access to this access point to requests from the specified virtual private cloud (VPC).  This is required for creating an access point for Amazon S3 on Outposts buckets. . Defaults to None.
        public_access_block_configuration(Dict, optional):  The PublicAccessBlock configuration that you want to apply to the access point. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.init.create(
                ctx, account_id=value, name=value, bucket=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.init.create account_id=value, name=value, bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="create_access_point",
        op_kwargs={
            "AccountId": account_id,
            "Name": name,
            "Bucket": bucket,
            "VpcConfiguration": vpc_configuration,
            "PublicAccessBlockConfiguration": public_access_block_configuration,
        },
    )


async def delete(hub, ctx, account_id: str, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified access point. All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section. The following actions are related to DeleteAccessPoint:    CreateAccessPoint     GetAccessPoint     ListAccessPoints

    Args:
        account_id(str): The account ID for the account that owns the specified access point.
        name(str): The name of the access point you want to delete. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>. For example, to access the access point reports-ap through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap. The value must be URL encoded. .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.init.delete(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.init.delete account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_access_point",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns configuration information about the specified access point.  All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section. The following actions are related to GetAccessPoint:    CreateAccessPoint     DeleteAccessPoint     ListAccessPoints

    Args:
        account_id(str): The account ID for the account that owns the specified access point.
        name(str): The name of the access point whose configuration information you want to retrieve. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the access point accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>. For example, to access the access point reports-ap through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap. The value must be URL encoded. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.init.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.init.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def list_all(
    hub,
    ctx,
    account_id: str,
    bucket: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the access points currently associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in maxResults, whichever is less), the response will include a continuation token that you can use to list the additional access points.  All Amazon S3 on Outposts REST API requests for this action require an additional parameter of x-amz-outpost-id to be passed with the request and an S3 on Outposts endpoint hostname prefix instead of s3-control. For an example of the request syntax for Amazon S3 on Outposts that uses the S3 on Outposts endpoint hostname prefix and the x-amz-outpost-id derived using the access point ARN, see the Examples section. The following actions are related to ListAccessPoints:    CreateAccessPoint     DeleteAccessPoint     GetAccessPoint

    Args:
        account_id(str): The account ID for owner of the bucket whose access points you want to list.
        bucket(str, optional): The name of the bucket whose associated access points you want to list. For using this parameter with Amazon S3 on Outposts with the REST API, you must specify the name and the x-amz-outpost-id as well. For using this parameter with S3 on Outposts with the Amazon Web Services SDK and CLI, you must specify the ARN of the bucket accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>. For example, to access the bucket reports through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports. The value must be URL encoded. . Defaults to None.
        next_token(str, optional): A continuation token. If a previous call to ListAccessPoints returned a continuation token in the NextToken field, then providing that value here causes Amazon S3 to retrieve the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of access points that you want to include in the list. If the specified bucket has more than this number of access points, then the response will include a continuation token in the NextToken field that you can use to retrieve the next page of access points. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.init.list_all(ctx, account_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.init.list_all account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="list_access_points",
        op_kwargs={
            "AccountId": account_id,
            "Bucket": bucket,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
