"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "for_object_lambda"


__func_alias__ = {"list_": "list"}


async def create(hub, ctx, account_id: str, name: str, configuration: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Object Lambda Access Point. For more information, see Transforming objects with Object Lambda Access Points in the Amazon S3 User Guide. The following actions are related to CreateAccessPointForObjectLambda:    DeleteAccessPointForObjectLambda     GetAccessPointForObjectLambda     ListAccessPointsForObjectLambda

    Args:
        account_id(str): The account ID for owner of the specified Object Lambda Access Point.
        name(str): The name you want to assign to this Object Lambda Access Point.
        configuration(Dict): Object Lambda Access Point configuration as a JSON document.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.for_object_lambda_.create(
                ctx, account_id=value, name=value, configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.for_object_lambda.create account_id=value, name=value, configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="create_access_point_for_object_lambda",
        op_kwargs={
            "AccountId": account_id,
            "Name": name,
            "Configuration": configuration,
        },
    )


async def delete(hub, ctx, account_id: str, name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified Object Lambda Access Point. The following actions are related to DeleteAccessPointForObjectLambda:    CreateAccessPointForObjectLambda     GetAccessPointForObjectLambda     ListAccessPointsForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the access point you want to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.for_object_lambda_.delete(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.for_object_lambda.delete account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="delete_access_point_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns configuration information about the specified Object Lambda Access Point The following actions are related to GetAccessPointForObjectLambda:    CreateAccessPointForObjectLambda     DeleteAccessPointForObjectLambda     ListAccessPointsForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.for_object_lambda_.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.for_object_lambda.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def list_(
    hub, ctx, account_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the access points associated with the Object Lambda Access Point. You can retrieve up to 1000 access points per call. If there are more than 1,000 access points (or the number specified in maxResults, whichever is less), the response will include a continuation token that you can use to list the additional access points. The following actions are related to ListAccessPointsForObjectLambda:    CreateAccessPointForObjectLambda     DeleteAccessPointForObjectLambda     GetAccessPointForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        next_token(str, optional): If the list has more access points than can be returned in one call to this API, this field contains a continuation token that you can provide in subsequent calls to this API to retrieve additional access points. Defaults to None.
        max_results(int, optional): The maximum number of access points that you want to include in the list. If there are more than this number of access points, then the response will include a continuation token in the NextToken field that you can use to retrieve the next page of access points. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.for_object_lambda_.list(
                ctx, account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.for_object_lambda.list account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="list_access_points_for_object_lambda",
        op_kwargs={
            "AccountId": account_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
