"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "configuration_for_object_lambda"


async def get(hub, ctx, account_id: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns configuration for an Object Lambda Access Point. The following actions are related to GetAccessPointConfigurationForObjectLambda:    PutAccessPointConfigurationForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point you want to return the configuration for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.configuration_for_object_lambda_.get(
                ctx, account_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.configuration_for_object_lambda.get account_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="get_access_point_configuration_for_object_lambda",
        op_kwargs={"AccountId": account_id, "Name": name},
    )


async def put(hub, ctx, account_id: str, name: str, configuration: Dict) -> None:
    r"""
    **Autogenerated function**

    Replaces configuration for an Object Lambda Access Point. The following actions are related to PutAccessPointConfigurationForObjectLambda:    GetAccessPointConfigurationForObjectLambda

    Args:
        account_id(str): The account ID for the account that owns the specified Object Lambda Access Point.
        name(str): The name of the Object Lambda Access Point.
        configuration(Dict): Object Lambda Access Point configuration document.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3control.access_point.configuration_for_object_lambda_.put(
                ctx, account_id=value, name=value, configuration=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3control.access_point.configuration_for_object_lambda.put account_id=value, name=value, configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3control",
        operation="put_access_point_configuration_for_object_lambda",
        op_kwargs={
            "AccountId": account_id,
            "Name": name,
            "Configuration": configuration,
        },
    )
