"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def upload(
    hub,
    ctx,
    bucket: str,
    copy_source: str,
    key: str,
    part_number: int,
    upload_id: str,
    copy_source_if_match: str = None,
    copy_source_if_modified_since: str = None,
    copy_source_if_none_match: str = None,
    copy_source_if_unmodified_since: str = None,
    copy_source_range: str = None,
    sse_customer_algorithm: str = None,
    sse_customer_key: str = None,
    sse_customer_key_md5: str = None,
    copy_source_sse_customer_algorithm: str = None,
    copy_source_sse_customer_key: str = None,
    copy_source_sse_customer_key_md5: str = None,
    request_payer: str = None,
    expected_bucket_owner: str = None,
    expected_source_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Uploads a part by copying data from an existing object as data source. You specify the data source by adding the request header x-amz-copy-source in your request and a byte range by adding the request header x-amz-copy-source-range in your request.  The minimum allowable part size for a multipart upload is 5 MB. For more information about multipart upload limits, go to Quick Facts in the Amazon S3 User Guide.   Instead of using an existing object as part data, you might use the UploadPart action and provide data in your request.  You must initiate a multipart upload before you can upload any part. In response to your initiate request. Amazon S3 returns a unique identifier, the upload ID, that you must include in your upload part request. For more information about using the UploadPartCopy operation, see the following:   For conceptual information about multipart uploads, see Uploading Objects Using Multipart Upload in the Amazon S3 User Guide.   For information about permissions required to use the multipart upload API, see Multipart Upload and Permissions in the Amazon S3 User Guide.   For information about copying objects using a single atomic action vs. the multipart upload, see Operations on Objects in the Amazon S3 User Guide.   For information about using server-side encryption with customer-provided encryption keys with the UploadPartCopy operation, see CopyObject and UploadPart.   Note the following additional considerations about the request headers x-amz-copy-source-if-match, x-amz-copy-source-if-none-match, x-amz-copy-source-if-unmodified-since, and x-amz-copy-source-if-modified-since:      Consideration 1 - If both of the x-amz-copy-source-if-match and x-amz-copy-source-if-unmodified-since headers are present in the request as follows:  x-amz-copy-source-if-match condition evaluates to true, and;  x-amz-copy-source-if-unmodified-since condition evaluates to false; Amazon S3 returns 200 OK and copies the data.     Consideration 2 - If both of the x-amz-copy-source-if-none-match and x-amz-copy-source-if-modified-since headers are present in the request as follows:  x-amz-copy-source-if-none-match condition evaluates to false, and;  x-amz-copy-source-if-modified-since condition evaluates to true; Amazon S3 returns 412 Precondition Failed response code.     Versioning  If your bucket has versioning enabled, you could have multiple versions of the same object. By default, x-amz-copy-source identifies the current version of the object to copy. If the current version is a delete marker and you don't specify a versionId in the x-amz-copy-source, Amazon S3 returns a 404 error, because the object does not exist. If you specify versionId in the x-amz-copy-source and the versionId is a delete marker, Amazon S3 returns an HTTP 400 error, because you are not allowed to specify a delete marker as a version for the x-amz-copy-source.  You can optionally specify a specific version of the source object to copy by adding the versionId subresource as shown in the following example:  x-amz-copy-source: /bucket/object?versionId=version id   Special Errors       Code: NoSuchUpload     Cause: The specified multipart upload does not exist. The upload ID might be invalid, or the multipart upload might have been aborted or completed.     HTTP Status Code: 404 Not Found         Code: InvalidRequest     Cause: The specified copy source is not supported as a byte-range copy source.     HTTP Status Code: 400 Bad Request       Related Resources     CreateMultipartUpload     UploadPart     CompleteMultipartUpload     AbortMultipartUpload     ListParts     ListMultipartUploads

    Args:
        bucket(str): The bucket name. When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        copy_source(str): Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an access point:   For objects not accessed through an access point, specify the name of the source bucket and key of the source object, separated by a slash (/). For example, to copy the object reports/january.pdf from the bucket awsexamplebucket, use awsexamplebucket/reports/january.pdf. The value must be URL encoded.   For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>. For example, to copy the object reports/january.pdf through access point my-access-point owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf. The value must be URL encoded.  Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same AWS Region.  Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>. For example, to copy the object reports/january.pdf through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf. The value must be URL encoded.    To copy a specific version of an object, append ?versionId=<version-id> to the value (for example, awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.
        copy_source_if_match(str, optional): Copies the object if its entity tag (ETag) matches the specified tag. Defaults to None.
        copy_source_if_modified_since(str, optional): Copies the object if it has been modified since the specified time. Defaults to None.
        copy_source_if_none_match(str, optional): Copies the object if its entity tag (ETag) is different than the specified ETag. Defaults to None.
        copy_source_if_unmodified_since(str, optional): Copies the object if it hasn't been modified since the specified time. Defaults to None.
        copy_source_range(str, optional): The range of bytes to copy from the source object. The range value must use the form bytes=first-last, where the first and last are the zero-based byte offsets to copy. For example, bytes=0-9 indicates that you want to copy the first 10 bytes of the source. You can copy a range only if the source object is greater than 5 MB. Defaults to None.
        key(str): Object key for which the multipart upload was initiated.
        part_number(int): Part number of part being copied. This is a positive integer between 1 and 10,000.
        upload_id(str): Upload ID identifying the multipart upload whose part is being copied.
        sse_customer_algorithm(str, optional): Specifies the algorithm to use to when encrypting the object (for example, AES256). Defaults to None.
        sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header. This must be the same encryption key specified in the initiate multipart upload request. Defaults to None.
        sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        copy_source_sse_customer_algorithm(str, optional): Specifies the algorithm to use when decrypting the source object (for example, AES256). Defaults to None.
        copy_source_sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created. Defaults to None.
        copy_source_sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.
        expected_source_bucket_owner(str, optional): The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.part.copy.upload(
                ctx, bucket=value, copy_source=value, key=value, part_number=value, upload_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.part.copy.upload bucket=value, copy_source=value, key=value, part_number=value, upload_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="upload_part_copy",
        op_kwargs={
            "Bucket": bucket,
            "CopySource": copy_source,
            "CopySourceIfMatch": copy_source_if_match,
            "CopySourceIfModifiedSince": copy_source_if_modified_since,
            "CopySourceIfNoneMatch": copy_source_if_none_match,
            "CopySourceIfUnmodifiedSince": copy_source_if_unmodified_since,
            "CopySourceRange": copy_source_range,
            "Key": key,
            "PartNumber": part_number,
            "UploadId": upload_id,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSECustomerKey": sse_customer_key,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "CopySourceSSECustomerAlgorithm": copy_source_sse_customer_algorithm,
            "CopySourceSSECustomerKey": copy_source_sse_customer_key,
            "CopySourceSSECustomerKeyMD5": copy_source_sse_customer_key_md5,
            "RequestPayer": request_payer,
            "ExpectedBucketOwner": expected_bucket_owner,
            "ExpectedSourceBucketOwner": expected_source_bucket_owner,
        },
    )
