"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    bucket: str,
    delimiter: str = None,
    encoding_type: str = None,
    key_marker: str = None,
    max_keys: int = None,
    prefix: str = None,
    version_id_marker: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns metadata about all versions of the objects in a bucket. You can also use request parameters as selection criteria to return metadata about a subset of all the object versions.   To use this operation, you must have permissions to perform the s3:ListBucketVersions action. Be aware of the name difference.     A 200 OK response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately.  To use this operation, you must have READ access to the bucket. This action is not supported by Amazon S3 on Outposts. The following operations are related to ListObjectVersions:    ListObjectsV2     GetObject     PutObject     DeleteObject

    Args:
        bucket(str): The bucket name that contains the objects. .
        delimiter(str, optional): A delimiter is a character that you specify to group keys. All keys that contain the same string between the prefix and the first occurrence of the delimiter are grouped under a single result element in CommonPrefixes. These groups are counted as one result against the max-keys limitation. These keys are not returned elsewhere in the response. Defaults to None.
        encoding_type(str, optional): Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response. Defaults to None.
        key_marker(str, optional): Specifies the key to start with when listing objects in a bucket. Defaults to None.
        max_keys(int, optional): Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. If additional keys satisfy the search criteria, but were not returned because max-keys was exceeded, the response contains <isTruncated>true</isTruncated>. To return the additional keys, see key-marker and version-id-marker. Defaults to None.
        prefix(str, optional): Use this parameter to select only those keys that begin with the specified prefix. You can use prefixes to separate a bucket into different groupings of keys. (You can think of using prefix to make groups in the same way you'd use a folder in a file system.) You can use prefix with delimiter to roll up numerous objects into a single result under CommonPrefixes. . Defaults to None.
        version_id_marker(str, optional): Specifies the object version you want to start listing from. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.version.list_all(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.version.list_all bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="list_object_versions",
        op_kwargs={
            "Bucket": bucket,
            "Delimiter": delimiter,
            "EncodingType": encoding_type,
            "KeyMarker": key_marker,
            "MaxKeys": max_keys,
            "Prefix": prefix,
            "VersionIdMarker": version_id_marker,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
