"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    bucket: str,
    key: str,
    request_payer: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files. For more information about BitTorrent, see Using BitTorrent with Amazon S3.  You can get torrent only for objects that are less than 5 GB in size, and that are not encrypted using server-side encryption with a customer-provided encryption key.  To use GET, you must have READ access to the object. This action is not supported by Amazon S3 on Outposts. The following action is related to GetObjectTorrent:    GetObject

    Args:
        bucket(str): The name of the bucket containing the object for which to get the torrent files.
        key(str): The object key for which to get the information.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.torrent.get(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.torrent.get bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_object_torrent",
        op_kwargs={
            "Bucket": bucket,
            "Key": key,
            "RequestPayer": request_payer,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
