"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    bucket: str,
    key: str,
    version_id: str = None,
    request_payer: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets an object's current Legal Hold status. For more information, see Locking Objects. This action is not supported by Amazon S3 on Outposts.

    Args:
        bucket(str): The bucket name containing the object whose Legal Hold status you want to retrieve.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide.
        key(str): The key name for the object whose Legal Hold status you want to retrieve.
        version_id(str, optional): The version ID of the object whose Legal Hold status you want to retrieve. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.legal_hold.get(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.legal_hold.get bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_object_legal_hold",
        op_kwargs={
            "Bucket": bucket,
            "Key": key,
            "VersionId": version_id,
            "RequestPayer": request_payer,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def put(
    hub,
    ctx,
    bucket: str,
    key: str,
    legal_hold: Dict = None,
    request_payer: str = None,
    version_id: str = None,
    content_md5: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Applies a Legal Hold configuration to the specified object. For more information, see Locking Objects. This action is not supported by Amazon S3 on Outposts.

    Args:
        bucket(str): The bucket name containing the object that you want to place a Legal Hold on.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide.
        key(str): The key name for the object that you want to place a Legal Hold on.
        legal_hold(Dict, optional): Container element for the Legal Hold configuration you want to apply to the specified object. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        version_id(str, optional): The version ID of the object that you want to place a Legal Hold on. Defaults to None.
        content_md5(str, optional): The MD5 hash for the request body. For requests made using the AWS Command Line Interface (CLI) or AWS SDKs, this field is calculated automatically. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.legal_hold.put(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.legal_hold.put bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="put_object_legal_hold",
        op_kwargs={
            "Bucket": bucket,
            "Key": key,
            "LegalHold": legal_hold,
            "RequestPayer": request_payer,
            "VersionId": version_id,
            "ContentMD5": content_md5,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
