"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def copy(
    hub,
    ctx,
    bucket: str,
    copy_source: str,
    key: str,
    acl: str = None,
    cache_control: str = None,
    content_disposition: str = None,
    content_encoding: str = None,
    content_language: str = None,
    content_type: str = None,
    copy_source_if_match: str = None,
    copy_source_if_modified_since: str = None,
    copy_source_if_none_match: str = None,
    copy_source_if_unmodified_since: str = None,
    expires: str = None,
    grant_full_control: str = None,
    grant_read: str = None,
    grant_read_acp: str = None,
    grant_write_acp: str = None,
    metadata: Dict = None,
    metadata_directive: str = None,
    tagging_directive: str = None,
    server_side_encryption: str = None,
    storage_class: str = None,
    website_redirect_location: str = None,
    sse_customer_algorithm: str = None,
    sse_customer_key: str = None,
    sse_customer_key_md5: str = None,
    ssekms_key_id: str = None,
    ssekms_encryption_context: str = None,
    bucket_key_enabled: bool = None,
    copy_source_sse_customer_algorithm: str = None,
    copy_source_sse_customer_key: str = None,
    copy_source_sse_customer_key_md5: str = None,
    request_payer: str = None,
    tagging: str = None,
    object_lock_mode: str = None,
    object_lock_retain_until_date: str = None,
    object_lock_legal_hold_status: str = None,
    expected_bucket_owner: str = None,
    expected_source_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a copy of an object that is already stored in Amazon S3.  You can store individual objects of up to 5 TB in Amazon S3. You create a copy of your object up to 5 GB in size in a single atomic action using this API. However, to copy an object greater than 5 GB, you must use the multipart upload Upload Part - Copy API. For more information, see Copy Object Using the REST Multipart Upload API.  All copy requests must be authenticated. Additionally, you must have read access to the source object and write access to the destination bucket. For more information, see REST Authentication. Both the Region that you want to copy the object from and the Region that you want to copy the object to must be enabled for your account. A copy request might return an error when Amazon S3 receives the copy request or while Amazon S3 is copying the files. If the error occurs before the copy action starts, you receive a standard Amazon S3 error. If the error occurs during the copy operation, the error response is embedded in the 200 OK response. This means that a 200 OK response can contain either a success or an error. Design your application to parse the contents of the response and handle it appropriately. If the copy is successful, you receive a response with information about the copied object.  If the request is an HTTP 1.1 request, the response is chunk encoded. If it were not, it would not contain the content-length, and you would need to read the entire body.  The copy request charge is based on the storage class and Region that you specify for the destination object. For pricing information, see Amazon S3 pricing.  Amazon S3 transfer acceleration does not support cross-Region copies. If you request a cross-Region copy using a transfer acceleration endpoint, you get a 400 Bad Request error. For more information, see Transfer Acceleration.   Metadata  When copying an object, you can preserve all metadata (default) or specify new metadata. However, the ACL is not preserved and is set to private for the user making the request. To override the default ACL setting, specify a new ACL when generating a copy request. For more information, see Using ACLs.  To specify whether you want the object metadata copied from the source object or replaced with metadata provided in the request, you can optionally add the x-amz-metadata-directive header. When you grant permissions, you can use the s3:x-amz-metadata-directive condition key to enforce certain metadata behavior when objects are uploaded. For more information, see Specifying Conditions in a Policy in the Amazon S3 User Guide. For a complete list of Amazon S3-specific condition keys, see Actions, Resources, and Condition Keys for Amazon S3.   x-amz-copy-source-if Headers  To only copy an object under certain conditions, such as whether the Etag matches or whether the object was modified before or after a specified date, use the following request parameters:    x-amz-copy-source-if-match     x-amz-copy-source-if-none-match     x-amz-copy-source-if-unmodified-since     x-amz-copy-source-if-modified-since     If both the x-amz-copy-source-if-match and x-amz-copy-source-if-unmodified-since headers are present in the request and evaluate as follows, Amazon S3 returns 200 OK and copies the data:    x-amz-copy-source-if-match condition evaluates to true    x-amz-copy-source-if-unmodified-since condition evaluates to false   If both the x-amz-copy-source-if-none-match and x-amz-copy-source-if-modified-since headers are present in the request and evaluate as follows, Amazon S3 returns the 412 Precondition Failed response code:    x-amz-copy-source-if-none-match condition evaluates to false    x-amz-copy-source-if-modified-since condition evaluates to true    All headers with the x-amz- prefix, including x-amz-copy-source, must be signed.   Server-side encryption  When you perform a CopyObject operation, you can optionally use the appropriate encryption-related headers to encrypt the object using server-side encryption with AWS managed encryption keys (SSE-S3 or SSE-KMS) or a customer-provided encryption key. With server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts the data when you access it. For more information about server-side encryption, see Using Server-Side Encryption. If a target object uses SSE-KMS, you can enable an S3 Bucket Key for the object. For more information, see Amazon S3 Bucket Keys in the Amazon S3 User Guide.  Access Control List (ACL)-Specific Request Headers  When copying an object, you can optionally use headers to grant ACL-based permissions. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual AWS accounts or to predefined groups defined by Amazon S3. These permissions are then added to the ACL on the object. For more information, see Access Control List (ACL) Overview and Managing ACLs Using the REST API.   Storage Class Options  You can use the CopyObject action to change the storage class of an object that is already stored in Amazon S3 using the StorageClass parameter. For more information, see Storage Classes in the Amazon S3 User Guide.  Versioning  By default, x-amz-copy-source identifies the current version of an object to copy. If the current version is a delete marker, Amazon S3 behaves as if the object was deleted. To copy a different version, use the versionId subresource. If you enable versioning on the target bucket, Amazon S3 generates a unique version ID for the object being copied. This version ID is different from the version ID of the source object. Amazon S3 returns the version ID of the copied object in the x-amz-version-id response header in the response. If you do not enable versioning or suspend it on the target bucket, the version ID that Amazon S3 generates is always null. If the source object's storage class is GLACIER, you must restore a copy of this object before you can use it as a source object for the copy operation. For more information, see RestoreObject. The following operations are related to CopyObject:    PutObject     GetObject    For more information, see Copying Objects.

    Args:
        acl(str, optional): The canned ACL to apply to the object. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        bucket(str): The name of the destination bucket. When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        cache_control(str, optional): Specifies caching behavior along the request/reply chain. Defaults to None.
        content_disposition(str, optional): Specifies presentational information for the object. Defaults to None.
        content_encoding(str, optional): Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Defaults to None.
        content_language(str, optional): The language the content is in. Defaults to None.
        content_type(str, optional): A standard MIME type describing the format of the object data. Defaults to None.
        copy_source(str): Specifies the source object for the copy operation. You specify the value in one of two formats, depending on whether you want to access the source object through an access point:   For objects not accessed through an access point, specify the name of the source bucket and the key of the source object, separated by a slash (/). For example, to copy the object reports/january.pdf from the bucket awsexamplebucket, use awsexamplebucket/reports/january.pdf. The value must be URL encoded.   For objects accessed through access points, specify the Amazon Resource Name (ARN) of the object as accessed through the access point, in the format arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>. For example, to copy the object reports/january.pdf through access point my-access-point owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf. The value must be URL encoded.  Amazon S3 supports copy operations using access points only when the source and destination buckets are in the same AWS Region.  Alternatively, for objects accessed through Amazon S3 on Outposts, specify the ARN of the object as accessed in the format arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>. For example, to copy the object reports/january.pdf through outpost my-outpost owned by account 123456789012 in Region us-west-2, use the URL encoding of arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf. The value must be URL encoded.    To copy a specific version of an object, append ?versionId=<version-id> to the value (for example, awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893). If you don't specify a version ID, Amazon S3 copies the latest version of the source object.
        copy_source_if_match(str, optional): Copies the object if its entity tag (ETag) matches the specified tag. Defaults to None.
        copy_source_if_modified_since(str, optional): Copies the object if it has been modified since the specified time. Defaults to None.
        copy_source_if_none_match(str, optional): Copies the object if its entity tag (ETag) is different than the specified ETag. Defaults to None.
        copy_source_if_unmodified_since(str, optional): Copies the object if it hasn't been modified since the specified time. Defaults to None.
        expires(str, optional): The date and time at which the object is no longer cacheable. Defaults to None.
        grant_full_control(str, optional): Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        grant_read(str, optional): Allows grantee to read the object data and its metadata. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        grant_read_acp(str, optional): Allows grantee to read the object ACL. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        grant_write_acp(str, optional): Allows grantee to write the ACL for the applicable object. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        key(str): The key of the destination object.
        metadata(Dict, optional): A map of metadata to store with the object in S3. Defaults to None.
        metadata_directive(str, optional): Specifies whether the metadata is copied from the source object or replaced with metadata provided in the request. Defaults to None.
        tagging_directive(str, optional): Specifies whether the object tag-set are copied from the source object or replaced with tag-set provided in the request. Defaults to None.
        server_side_encryption(str, optional): The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms). Defaults to None.
        storage_class(str, optional): By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see Storage Classes in the Amazon S3 User Guide. Defaults to None.
        website_redirect_location(str, optional): If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. Defaults to None.
        sse_customer_algorithm(str, optional): Specifies the algorithm to use to when encrypting the object (for example, AES256). Defaults to None.
        sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header. Defaults to None.
        sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        ssekms_key_id(str, optional): Specifies the AWS KMS key ID to use for object encryption. All GET and PUT requests for an object protected by AWS KMS will fail if not made via SSL or using SigV4. For information about configuring using any of the officially supported AWS SDKs and AWS CLI, see Specifying the Signature Version in Request Authentication in the Amazon S3 User Guide. Defaults to None.
        ssekms_encryption_context(str, optional): Specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. Defaults to None.
        bucket_key_enabled(bool, optional): Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to true causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS.  Specifying this header with a COPY action doesn’t affect bucket-level settings for S3 Bucket Key. Defaults to None.
        copy_source_sse_customer_algorithm(str, optional): Specifies the algorithm to use when decrypting the source object (for example, AES256). Defaults to None.
        copy_source_sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 to use to decrypt the source object. The encryption key provided in this header must be one that was used when the source object was created. Defaults to None.
        copy_source_sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        tagging(str, optional): The tag-set for the object destination object this value must be used in conjunction with the TaggingDirective. The tag-set must be encoded as URL Query parameters. Defaults to None.
        object_lock_mode(str, optional): The Object Lock mode that you want to apply to the copied object. Defaults to None.
        object_lock_retain_until_date(str, optional): The date and time when you want the copied object's Object Lock to expire. Defaults to None.
        object_lock_legal_hold_status(str, optional): Specifies whether you want to apply a Legal Hold to the copied object. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected destination bucket owner. If the destination bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.
        expected_source_bucket_owner(str, optional): The account ID of the expected source bucket owner. If the source bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.copy(
                ctx, bucket=value, copy_source=value, key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.copy bucket=value, copy_source=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="copy_object",
        op_kwargs={
            "ACL": acl,
            "Bucket": bucket,
            "CacheControl": cache_control,
            "ContentDisposition": content_disposition,
            "ContentEncoding": content_encoding,
            "ContentLanguage": content_language,
            "ContentType": content_type,
            "CopySource": copy_source,
            "CopySourceIfMatch": copy_source_if_match,
            "CopySourceIfModifiedSince": copy_source_if_modified_since,
            "CopySourceIfNoneMatch": copy_source_if_none_match,
            "CopySourceIfUnmodifiedSince": copy_source_if_unmodified_since,
            "Expires": expires,
            "GrantFullControl": grant_full_control,
            "GrantRead": grant_read,
            "GrantReadACP": grant_read_acp,
            "GrantWriteACP": grant_write_acp,
            "Key": key,
            "Metadata": metadata,
            "MetadataDirective": metadata_directive,
            "TaggingDirective": tagging_directive,
            "ServerSideEncryption": server_side_encryption,
            "StorageClass": storage_class,
            "WebsiteRedirectLocation": website_redirect_location,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSECustomerKey": sse_customer_key,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "SSEKMSKeyId": ssekms_key_id,
            "SSEKMSEncryptionContext": ssekms_encryption_context,
            "BucketKeyEnabled": bucket_key_enabled,
            "CopySourceSSECustomerAlgorithm": copy_source_sse_customer_algorithm,
            "CopySourceSSECustomerKey": copy_source_sse_customer_key,
            "CopySourceSSECustomerKeyMD5": copy_source_sse_customer_key_md5,
            "RequestPayer": request_payer,
            "Tagging": tagging,
            "ObjectLockMode": object_lock_mode,
            "ObjectLockRetainUntilDate": object_lock_retain_until_date,
            "ObjectLockLegalHoldStatus": object_lock_legal_hold_status,
            "ExpectedBucketOwner": expected_bucket_owner,
            "ExpectedSourceBucketOwner": expected_source_bucket_owner,
        },
    )


async def delete(
    hub,
    ctx,
    bucket: str,
    key: str,
    mfa: str = None,
    version_id: str = None,
    request_payer: str = None,
    bypass_governance_retention: bool = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest version of the object. If there isn't a null version, Amazon S3 does not remove any objects but will still respond that the command was successful. To remove a specific version, you must be the bucket owner and you must use the version Id subresource. Using this subresource permanently deletes the version. If the object deleted is a delete marker, Amazon S3 sets the response header, x-amz-delete-marker, to true.  If the object you want to delete is in a bucket where the bucket versioning configuration is MFA Delete enabled, you must include the x-amz-mfa request header in the DELETE versionId request. Requests that include x-amz-mfa must use HTTPS.   For more information about MFA Delete, see Using MFA Delete. To see sample requests that use versioning, see Sample Request.  You can delete objects by explicitly calling DELETE Object or configure its lifecycle (PutBucketLifecycle) to enable Amazon S3 to remove them for you. If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them the s3:DeleteObject, s3:DeleteObjectVersion, and s3:PutLifeCycleConfiguration actions.  The following action is related to DeleteObject:    PutObject

    Args:
        bucket(str): The bucket name of the bucket containing the object.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        key(str): Key name of the object to delete.
        mfa(str, optional): The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled. Defaults to None.
        version_id(str, optional): VersionId used to reference a specific version of the object. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        bypass_governance_retention(bool, optional): Indicates whether S3 Object Lock should bypass Governance-mode restrictions to process this operation. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.delete(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.delete bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="delete_object",
        op_kwargs={
            "Bucket": bucket,
            "Key": key,
            "MFA": mfa,
            "VersionId": version_id,
            "RequestPayer": request_payer,
            "BypassGovernanceRetention": bypass_governance_retention,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def delete_multiple(
    hub,
    ctx,
    bucket: str,
    delete: Dict,
    mfa: str = None,
    request_payer: str = None,
    bypass_governance_retention: bool = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This action enables you to delete multiple objects from a bucket using a single HTTP request. If you know the object keys that you want to delete, then this action provides a suitable alternative to sending individual delete requests, reducing per-request overhead. The request contains a list of up to 1000 keys that you want to delete. In the XML, you provide the object key names, and optionally, version IDs if you want to delete a specific version of the object from a versioning-enabled bucket. For each key, Amazon S3 performs a delete action and returns the result of that delete, success, or failure, in the response. Note that if the object specified in the request is not found, Amazon S3 returns the result as deleted.  The action supports two modes for the response: verbose and quiet. By default, the action uses verbose mode in which the response includes the result of deletion of each key in your request. In quiet mode the response includes only keys where the delete action encountered an error. For a successful deletion, the action does not return any information about the delete in the response body. When performing this action on an MFA Delete enabled bucket, that attempts to delete any versioned objects, you must include an MFA token. If you do not provide one, the entire request will fail, even if there are non-versioned objects you are trying to delete. If you provide an invalid token, whether there are versioned keys in the request or not, the entire Multi-Object Delete request will fail. For information about MFA Delete, see  MFA Delete. Finally, the Content-MD5 header is required for all Multi-Object Delete requests. Amazon S3 uses the header value to ensure that your request body has not been altered in transit. The following operations are related to DeleteObjects:    CreateMultipartUpload     UploadPart     CompleteMultipartUpload     ListParts     AbortMultipartUpload

    Args:
        bucket(str): The bucket name containing the objects to delete.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        delete(Dict): Container for the request.
        mfa(str, optional): The concatenation of the authentication device's serial number, a space, and the value that is displayed on your authentication device. Required to permanently delete a versioned object if versioning is configured with MFA delete enabled. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        bypass_governance_retention(bool, optional): Specifies whether you want to delete this object even if it has a Governance-type Object Lock in place. You must have sufficient permissions to perform this operation. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.delete_multiple(ctx, bucket=value, delete=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.delete_multiple bucket=value, delete=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="delete_objects",
        op_kwargs={
            "Bucket": bucket,
            "Delete": delete,
            "MFA": mfa,
            "RequestPayer": request_payer,
            "BypassGovernanceRetention": bypass_governance_retention,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def get(
    hub,
    ctx,
    bucket: str,
    key: str,
    if_match: str = None,
    if_modified_since: str = None,
    if_none_match: str = None,
    if_unmodified_since: str = None,
    range_: str = None,
    response_cache_control: str = None,
    response_content_disposition: str = None,
    response_content_encoding: str = None,
    response_content_language: str = None,
    response_content_type: str = None,
    response_expires: str = None,
    version_id: str = None,
    sse_customer_algorithm: str = None,
    sse_customer_key: str = None,
    sse_customer_key_md5: str = None,
    request_payer: str = None,
    part_number: int = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves objects from Amazon S3. To use GET, you must have READ access to the object. If you grant READ access to the anonymous user, you can return the object without using an authorization header. An Amazon S3 bucket has no directory hierarchy such as you would find in a typical computer file system. You can, however, create a logical hierarchy by using object key names that imply a folder structure. For example, instead of naming an object sample.jpg, you can name it photos/2006/February/sample.jpg. To get an object from such a logical hierarchy, specify the full key name for the object in the GET operation. For a virtual hosted-style request example, if you have the object photos/2006/February/sample.jpg, specify the resource as /photos/2006/February/sample.jpg. For a path-style request example, if you have the object photos/2006/February/sample.jpg in the bucket named examplebucket, specify the resource as /examplebucket/photos/2006/February/sample.jpg. For more information about request types, see HTTP Host Header Bucket Specification. To distribute large files to many people, you can save bandwidth costs by using BitTorrent. For more information, see Amazon S3 Torrent. For more information about returning the ACL of an object, see GetObjectAcl. If the object you are retrieving is stored in the S3 Glacier or S3 Glacier Deep Archive storage class, or S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering Deep Archive tiers, before you can retrieve the object you must first restore a copy using RestoreObject. Otherwise, this action returns an InvalidObjectStateError error. For information about restoring archived objects, see Restoring Archived Objects. Encryption request headers, like x-amz-server-side-encryption, should not be sent for GET requests if your object uses server-side encryption with CMKs stored in AWS KMS (SSE-KMS) or server-side encryption with Amazon S3–managed encryption keys (SSE-S3). If your object does use these types of keys, you’ll get an HTTP 400 BadRequest error. If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you GET the object, you must use the following headers:   x-amz-server-side-encryption-customer-algorithm   x-amz-server-side-encryption-customer-key   x-amz-server-side-encryption-customer-key-MD5   For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided Encryption Keys). Assuming you have permission to read object tags (permission for the s3:GetObjectVersionTagging action), the response also returns the x-amz-tagging-count header that provides the count of number of tags associated with the object. You can use GetObjectTagging to retrieve the tag set associated with an object.  Permissions  You need the s3:GetObject permission for this operation. For more information, see Specifying Permissions in a Policy. If the object you request does not exist, the error Amazon S3 returns depends on whether you also have the s3:ListBucket permission.   If you have the s3:ListBucket permission on the bucket, Amazon S3 will return an HTTP status code 404 ("no such key") error.   If you don’t have the s3:ListBucket permission, Amazon S3 will return an HTTP status code 403 ("access denied") error.    Versioning  By default, the GET action returns the current version of an object. To return a different version, use the versionId subresource.  If the current version of the object is a delete marker, Amazon S3 behaves as if the object was deleted and includes x-amz-delete-marker: true in the response.  For more information about versioning, see PutBucketVersioning.   Overriding Response Header Values  There are times when you want to override certain response header values in a GET response. For example, you might override the Content-Disposition response header value in your GET request. You can override values for a set of response headers using the following query parameters. These response header values are sent only on a successful request, that is, when status code 200 OK is returned. The set of headers you can override using these parameters is a subset of the headers that Amazon S3 accepts when you create an object. The response headers that you can override for the GET response are Content-Type, Content-Language, Expires, Cache-Control, Content-Disposition, and Content-Encoding. To override these header values in the GET response, you use the following request parameters.  You must sign the request, either using an Authorization header or a presigned URL, when using these parameters. They cannot be used with an unsigned (anonymous) request.     response-content-type     response-content-language     response-expires     response-cache-control     response-content-disposition     response-content-encoding     Additional Considerations about Request Headers  If both of the If-Match and If-Unmodified-Since headers are present in the request as follows: If-Match condition evaluates to true, and; If-Unmodified-Since condition evaluates to false; then, S3 returns 200 OK and the data requested.  If both of the If-None-Match and If-Modified-Since headers are present in the request as follows: If-None-Match condition evaluates to false, and; If-Modified-Since condition evaluates to true; then, S3 returns 304 Not Modified response code. For more information about conditional requests, see RFC 7232. The following operations are related to GetObject:    ListBuckets     GetObjectAcl

    Args:
        bucket(str): The bucket name containing the object.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        if_match(str, optional): Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed). Defaults to None.
        if_modified_since(str, optional): Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified). Defaults to None.
        if_none_match(str, optional): Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified). Defaults to None.
        if_unmodified_since(str, optional): Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed). Defaults to None.
        key(str): Key of the object to get.
        range_(str, optional): Downloads the specified range bytes of an object. For more information about the HTTP Range header, see https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.  Amazon S3 doesn't support retrieving multiple ranges of data per GET request. . Defaults to None.
        response_cache_control(str, optional): Sets the Cache-Control header of the response. Defaults to None.
        response_content_disposition(str, optional): Sets the Content-Disposition header of the response. Defaults to None.
        response_content_encoding(str, optional): Sets the Content-Encoding header of the response. Defaults to None.
        response_content_language(str, optional): Sets the Content-Language header of the response. Defaults to None.
        response_content_type(str, optional): Sets the Content-Type header of the response. Defaults to None.
        response_expires(str, optional): Sets the Expires header of the response. Defaults to None.
        version_id(str, optional): VersionId used to reference a specific version of the object. Defaults to None.
        sse_customer_algorithm(str, optional): Specifies the algorithm to use to when decrypting the object (for example, AES256). Defaults to None.
        sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 used to encrypt the data. This value is used to decrypt the object when recovering it and must match the one used when storing the data. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header. Defaults to None.
        sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        part_number(int, optional): Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' GET request for the part specified. Useful for downloading just a part of an object. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.get(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.get bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_object",
        op_kwargs={
            "Bucket": bucket,
            "IfMatch": if_match,
            "IfModifiedSince": if_modified_since,
            "IfNoneMatch": if_none_match,
            "IfUnmodifiedSince": if_unmodified_since,
            "Key": key,
            "Range": range_,
            "ResponseCacheControl": response_cache_control,
            "ResponseContentDisposition": response_content_disposition,
            "ResponseContentEncoding": response_content_encoding,
            "ResponseContentLanguage": response_content_language,
            "ResponseContentType": response_content_type,
            "ResponseExpires": response_expires,
            "VersionId": version_id,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSECustomerKey": sse_customer_key,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "RequestPayer": request_payer,
            "PartNumber": part_number,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def head(
    hub,
    ctx,
    bucket: str,
    key: str,
    if_match: str = None,
    if_modified_since: str = None,
    if_none_match: str = None,
    if_unmodified_since: str = None,
    range_: str = None,
    version_id: str = None,
    sse_customer_algorithm: str = None,
    sse_customer_key: str = None,
    sse_customer_key_md5: str = None,
    request_payer: str = None,
    part_number: int = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The HEAD action retrieves metadata from an object without returning the object itself. This action is useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object. A HEAD request has the same options as a GET action on an object. The response is identical to the GET response except that there is no response body. Because of this, if the HEAD request generates an error, it returns a generic 404 Not Found or 403 Forbidden code. It is not possible to retrieve the exact exception beyond these error codes. If you encrypt an object by using server-side encryption with customer-provided encryption keys (SSE-C) when you store the object in Amazon S3, then when you retrieve the metadata from the object, you must use the following headers:   x-amz-server-side-encryption-customer-algorithm   x-amz-server-side-encryption-customer-key   x-amz-server-side-encryption-customer-key-MD5   For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided Encryption Keys).    Encryption request headers, like x-amz-server-side-encryption, should not be sent for GET requests if your object uses server-side encryption with CMKs stored in AWS KMS (SSE-KMS) or server-side encryption with Amazon S3–managed encryption keys (SSE-S3). If your object does use these types of keys, you’ll get an HTTP 400 BadRequest error.    The last modified property in this case is the creation date of the object.    Request headers are limited to 8 KB in size. For more information, see Common Request Headers. Consider the following when using request headers:    Consideration 1 – If both of the If-Match and If-Unmodified-Since headers are present in the request as follows:    If-Match condition evaluates to true, and;    If-Unmodified-Since condition evaluates to false;   Then Amazon S3 returns 200 OK and the data requested.    Consideration 2 – If both of the If-None-Match and If-Modified-Since headers are present in the request as follows:    If-None-Match condition evaluates to false, and;    If-Modified-Since condition evaluates to true;   Then Amazon S3 returns the 304 Not Modified response code.   For more information about conditional requests, see RFC 7232.  Permissions  You need the s3:GetObject permission for this operation. For more information, see Specifying Permissions in a Policy. If the object you request does not exist, the error Amazon S3 returns depends on whether you also have the s3:ListBucket permission.   If you have the s3:ListBucket permission on the bucket, Amazon S3 returns an HTTP status code 404 ("no such key") error.   If you don’t have the s3:ListBucket permission, Amazon S3 returns an HTTP status code 403 ("access denied") error.   The following action is related to HeadObject:    GetObject

    Args:
        bucket(str): The name of the bucket containing the object. When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        if_match(str, optional): Return the object only if its entity tag (ETag) is the same as the one specified, otherwise return a 412 (precondition failed). Defaults to None.
        if_modified_since(str, optional): Return the object only if it has been modified since the specified time, otherwise return a 304 (not modified). Defaults to None.
        if_none_match(str, optional): Return the object only if its entity tag (ETag) is different from the one specified, otherwise return a 304 (not modified). Defaults to None.
        if_unmodified_since(str, optional): Return the object only if it has not been modified since the specified time, otherwise return a 412 (precondition failed). Defaults to None.
        key(str): The object key.
        range_(str, optional): Downloads the specified range bytes of an object. For more information about the HTTP Range header, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35.  Amazon S3 doesn't support retrieving multiple ranges of data per GET request. . Defaults to None.
        version_id(str, optional): VersionId used to reference a specific version of the object. Defaults to None.
        sse_customer_algorithm(str, optional): Specifies the algorithm to use to when encrypting the object (for example, AES256). Defaults to None.
        sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header. Defaults to None.
        sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        part_number(int, optional): Part number of the object being read. This is a positive integer between 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part specified. Useful querying about the size of the part and the number of parts in this object. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.head(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.head bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="head_object",
        op_kwargs={
            "Bucket": bucket,
            "IfMatch": if_match,
            "IfModifiedSince": if_modified_since,
            "IfNoneMatch": if_none_match,
            "IfUnmodifiedSince": if_unmodified_since,
            "Key": key,
            "Range": range_,
            "VersionId": version_id,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSECustomerKey": sse_customer_key,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "RequestPayer": request_payer,
            "PartNumber": part_number,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def list_all(
    hub,
    ctx,
    bucket: str,
    delimiter: str = None,
    encoding_type: str = None,
    marker: str = None,
    max_keys: int = None,
    prefix: str = None,
    request_payer: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be sure to design your application to parse the contents of the response and handle it appropriately.  This action has been revised. We recommend that you use the newer version, ListObjectsV2, when developing applications. For backward compatibility, Amazon S3 continues to support ListObjects.  The following operations are related to ListObjects:    ListObjectsV2     GetObject     PutObject     CreateBucket     ListBuckets

    Args:
        bucket(str): The name of the bucket containing the objects. When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        delimiter(str, optional): A delimiter is a character you use to group keys. Defaults to None.
        encoding_type(str, optional): Requests Amazon S3 to encode the object keys in the response and specifies the encoding method to use. An object key may contain any Unicode character; however, XML 1.0 parser cannot parse some characters, such as characters with an ASCII value from 0 to 10. For characters that are not supported in XML 1.0, you can add this parameter to request that Amazon S3 encode the keys in the response. Defaults to None.
        marker(str, optional): Specifies the key to start with when listing objects in a bucket. Defaults to None.
        max_keys(int, optional): Sets the maximum number of keys returned in the response. By default the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more. . Defaults to None.
        prefix(str, optional): Limits the response to keys that begin with the specified prefix. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that she or he will be charged for the list objects request. Bucket owners need not specify this parameter in their requests. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.list_all(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.list_all bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="list_objects",
        op_kwargs={
            "Bucket": bucket,
            "Delimiter": delimiter,
            "EncodingType": encoding_type,
            "Marker": marker,
            "MaxKeys": max_keys,
            "Prefix": prefix,
            "RequestPayer": request_payer,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def put(
    hub,
    ctx,
    bucket: str,
    key: str,
    acl: str = None,
    body: bytes = None,
    cache_control: str = None,
    content_disposition: str = None,
    content_encoding: str = None,
    content_language: str = None,
    content_length: int = None,
    content_md5: str = None,
    content_type: str = None,
    expires: str = None,
    grant_full_control: str = None,
    grant_read: str = None,
    grant_read_acp: str = None,
    grant_write_acp: str = None,
    metadata: Dict = None,
    server_side_encryption: str = None,
    storage_class: str = None,
    website_redirect_location: str = None,
    sse_customer_algorithm: str = None,
    sse_customer_key: str = None,
    sse_customer_key_md5: str = None,
    ssekms_key_id: str = None,
    ssekms_encryption_context: str = None,
    bucket_key_enabled: bool = None,
    request_payer: str = None,
    tagging: str = None,
    object_lock_mode: str = None,
    object_lock_retain_until_date: str = None,
    object_lock_legal_hold_status: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an object to a bucket. You must have WRITE permissions on a bucket to add an object to it. Amazon S3 never adds partial objects; if you receive a success response, Amazon S3 added the entire object to the bucket. Amazon S3 is a distributed system. If it receives multiple write requests for the same object simultaneously, it overwrites all but the last object written. Amazon S3 does not provide object locking; if you need this, make sure to build it into your application layer or use versioning instead. To ensure that data is not corrupted traversing the network, use the Content-MD5 header. When you use this header, Amazon S3 checks the object against the provided MD5 value and, if they do not match, returns an error. Additionally, you can calculate the MD5 while putting an object to Amazon S3 and compare the returned ETag to the calculated MD5 value.   The Content-MD5 header is required for any request to upload an object with a retention period configured using Amazon S3 Object Lock. For more information about Amazon S3 Object Lock, see Amazon S3 Object Lock Overview in the Amazon S3 User Guide.    Server-side Encryption  You can optionally request server-side encryption. With server-side encryption, Amazon S3 encrypts your data as it writes it to disks in its data centers and decrypts the data when you access it. You have the option to provide your own encryption key or use AWS managed encryption keys (SSE-S3 or SSE-KMS). For more information, see Using Server-Side Encryption. If you request server-side encryption using AWS Key Management Service (SSE-KMS), you can enable an S3 Bucket Key at the object-level. For more information, see Amazon S3 Bucket Keys in the Amazon S3 User Guide.  Access Control List (ACL)-Specific Request Headers  You can use headers to grant ACL- based permissions. By default, all objects are private. Only the owner has full access control. When adding a new object, you can grant permissions to individual AWS accounts or to predefined groups defined by Amazon S3. These permissions are then added to the ACL on the object. For more information, see Access Control List (ACL) Overview and Managing ACLs Using the REST API.   Storage Class Options  By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see Storage Classes in the Amazon S3 User Guide.  Versioning  If you enable versioning for a bucket, Amazon S3 automatically generates a unique version ID for the object being stored. Amazon S3 returns this ID in the response. When you enable versioning for a bucket, if Amazon S3 receives multiple write requests for the same object simultaneously, it stores all of the objects. For more information about versioning, see Adding Objects to Versioning Enabled Buckets. For information about returning the versioning state of a bucket, see GetBucketVersioning.   Related Resources     CopyObject     DeleteObject

    Args:
        acl(str, optional): The canned ACL to apply to the object. For more information, see Canned ACL. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        body(bytes, optional): Object data. Defaults to None.
        bucket(str): The bucket name to which the PUT action was initiated.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        cache_control(str, optional):  Can be used to specify caching behavior along the request/reply chain. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9. Defaults to None.
        content_disposition(str, optional): Specifies presentational information for the object. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1. Defaults to None.
        content_encoding(str, optional): Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11. Defaults to None.
        content_language(str, optional): The language the content is in. Defaults to None.
        content_length(int, optional): Size of the body in bytes. This parameter is useful when the size of the body cannot be determined automatically. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13. Defaults to None.
        content_md5(str, optional): The base64-encoded 128-bit MD5 digest of the message (without the headers) according to RFC 1864. This header can be used as a message integrity check to verify that the data is the same data that was originally sent. Although it is optional, we recommend using the Content-MD5 mechanism as an end-to-end integrity check. For more information about REST request authentication, see REST Authentication. Defaults to None.
        content_type(str, optional): A standard MIME type describing the format of the contents. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17. Defaults to None.
        expires(str, optional): The date and time at which the object is no longer cacheable. For more information, see http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21. Defaults to None.
        grant_full_control(str, optional): Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the object. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        grant_read(str, optional): Allows grantee to read the object data and its metadata. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        grant_read_acp(str, optional): Allows grantee to read the object ACL. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        grant_write_acp(str, optional): Allows grantee to write the ACL for the applicable object. This action is not supported by Amazon S3 on Outposts. Defaults to None.
        key(str): Object key for which the PUT action was initiated.
        metadata(Dict, optional): A map of metadata to store with the object in S3. Defaults to None.
        server_side_encryption(str, optional): The server-side encryption algorithm used when storing this object in Amazon S3 (for example, AES256, aws:kms). Defaults to None.
        storage_class(str, optional): By default, Amazon S3 uses the STANDARD Storage Class to store newly created objects. The STANDARD storage class provides high durability and high availability. Depending on performance needs, you can specify a different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS Storage Class. For more information, see Storage Classes in the Amazon S3 User Guide. Defaults to None.
        website_redirect_location(str, optional): If the bucket is configured as a website, redirects requests for this object to another object in the same bucket or to an external URL. Amazon S3 stores the value of this header in the object metadata. For information about object metadata, see Object Key and Metadata. In the following example, the request header sets the redirect to an object (anotherPage.html) in the same bucket:  x-amz-website-redirect-location: /anotherPage.html  In the following example, the request header sets the object redirect to another website:  x-amz-website-redirect-location: http://www.example.com/  For more information about website hosting in Amazon S3, see Hosting Websites on Amazon S3 and How to Configure Website Page Redirects. . Defaults to None.
        sse_customer_algorithm(str, optional): Specifies the algorithm to use to when encrypting the object (for example, AES256). Defaults to None.
        sse_customer_key(str, optional): Specifies the customer-provided encryption key for Amazon S3 to use in encrypting data. This value is used to store the object and then it is discarded; Amazon S3 does not store the encryption key. The key must be appropriate for use with the algorithm specified in the x-amz-server-side-encryption-customer-algorithm header. Defaults to None.
        sse_customer_key_md5(str, optional): Specifies the 128-bit MD5 digest of the encryption key according to RFC 1321. Amazon S3 uses this header for a message integrity check to ensure that the encryption key was transmitted without error. Defaults to None.
        ssekms_key_id(str, optional): If x-amz-server-side-encryption is present and has the value of aws:kms, this header specifies the ID of the AWS Key Management Service (AWS KMS) symmetrical customer managed customer master key (CMK) that was used for the object. If you specify x-amz-server-side-encryption:aws:kms, but do not provide x-amz-server-side-encryption-aws-kms-key-id, Amazon S3 uses the AWS managed CMK in AWS to protect the data. If the KMS key does not exist in the same account issuing the command, you must use the full ARN and not just the ID. . Defaults to None.
        ssekms_encryption_context(str, optional): Specifies the AWS KMS Encryption Context to use for object encryption. The value of this header is a base64-encoded UTF-8 string holding JSON with the encryption context key-value pairs. Defaults to None.
        bucket_key_enabled(bool, optional): Specifies whether Amazon S3 should use an S3 Bucket Key for object encryption with server-side encryption using AWS KMS (SSE-KMS). Setting this header to true causes Amazon S3 to use an S3 Bucket Key for object encryption with SSE-KMS. Specifying this header with a PUT action doesn’t affect bucket-level settings for S3 Bucket Key. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        tagging(str, optional): The tag-set for the object. The tag-set must be encoded as URL Query parameters. (For example, "Key1=Value1"). Defaults to None.
        object_lock_mode(str, optional): The Object Lock mode that you want to apply to this object. Defaults to None.
        object_lock_retain_until_date(str, optional): The date and time when you want this object's Object Lock to expire. Must be formatted as a timestamp parameter. Defaults to None.
        object_lock_legal_hold_status(str, optional): Specifies whether a legal hold will be applied to this object. For more information about S3 Object Lock, see Object Lock. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.put(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.put bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="put_object",
        op_kwargs={
            "ACL": acl,
            "Body": body,
            "Bucket": bucket,
            "CacheControl": cache_control,
            "ContentDisposition": content_disposition,
            "ContentEncoding": content_encoding,
            "ContentLanguage": content_language,
            "ContentLength": content_length,
            "ContentMD5": content_md5,
            "ContentType": content_type,
            "Expires": expires,
            "GrantFullControl": grant_full_control,
            "GrantRead": grant_read,
            "GrantReadACP": grant_read_acp,
            "GrantWriteACP": grant_write_acp,
            "Key": key,
            "Metadata": metadata,
            "ServerSideEncryption": server_side_encryption,
            "StorageClass": storage_class,
            "WebsiteRedirectLocation": website_redirect_location,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSECustomerKey": sse_customer_key,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "SSEKMSKeyId": ssekms_key_id,
            "SSEKMSEncryptionContext": ssekms_encryption_context,
            "BucketKeyEnabled": bucket_key_enabled,
            "RequestPayer": request_payer,
            "Tagging": tagging,
            "ObjectLockMode": object_lock_mode,
            "ObjectLockRetainUntilDate": object_lock_retain_until_date,
            "ObjectLockLegalHoldStatus": object_lock_legal_hold_status,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )


async def restore(
    hub,
    ctx,
    bucket: str,
    key: str,
    version_id: str = None,
    restore_request: Dict = None,
    request_payer: str = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Restores an archived copy of an object back into Amazon S3 This action is not supported by Amazon S3 on Outposts. This action performs the following types of requests:     select - Perform a select query on an archived object    restore an archive - Restore an archived object   To use this operation, you must have permissions to perform the s3:RestoreObject action. The bucket owner has this permission by default and can grant this permission to others. For more information about permissions, see Permissions Related to Bucket Subresource Operations and Managing Access Permissions to Your Amazon S3 Resources in the Amazon S3 User Guide.  Querying Archives with Select Requests  You use a select type of request to perform SQL queries on archived objects. The archived objects that are being queried by the select request must be formatted as uncompressed comma-separated values (CSV) files. You can run queries and custom analytics on your archived data without having to restore your data to a hotter Amazon S3 tier. For an overview about select requests, see Querying Archived Objects in the Amazon S3 User Guide. When making a select request, do the following:   Define an output location for the select query's output. This must be an Amazon S3 bucket in the same AWS Region as the bucket that contains the archive object that is being queried. The AWS account that initiates the job must have permissions to write to the S3 bucket. You can specify the storage class and encryption for the output objects stored in the bucket. For more information about output, see Querying Archived Objects in the Amazon S3 User Guide. For more information about the S3 structure in the request body, see the following:    PutObject     Managing Access with ACLs in the Amazon S3 User Guide     Protecting Data Using Server-Side Encryption in the Amazon S3 User Guide      Define the SQL expression for the SELECT type of restoration for your query in the request body's SelectParameters structure. You can use expressions like the following examples.   The following expression returns all records from the specified object.  SELECT * FROM Object    Assuming that you are not using any headers for data stored in the object, you can specify columns with positional headers.  SELECT s._1, s._2 FROM Object s WHERE s._3 > 100    If you have headers and you set the fileHeaderInfo in the CSV structure in the request body to USE, you can specify headers in the query. (If you set the fileHeaderInfo field to IGNORE, the first row is skipped for the query.) You cannot mix ordinal positions with header column names.   SELECT s.Id, s.FirstName, s.SSN FROM S3Object s      For more information about using SQL with S3 Glacier Select restore, see SQL Reference for Amazon S3 Select and S3 Glacier Select in the Amazon S3 User Guide.  When making a select request, you can also do the following:   To expedite your queries, specify the Expedited tier. For more information about tiers, see "Restoring Archives," later in this topic.   Specify details about the data serialization format of both the input object that is being queried and the serialization of the CSV-encoded query results.   The following are additional important facts about the select feature:   The output results are new Amazon S3 objects. Unlike archive retrievals, they are stored until explicitly deleted-manually or through a lifecycle policy.   You can issue more than one select request on the same Amazon S3 object. Amazon S3 doesn't deduplicate requests, so avoid issuing duplicate requests.    Amazon S3 accepts a select request even if the object has already been restored. A select request doesn’t return error response 409.    Restoring objects  Objects that you archive to the S3 Glacier or S3 Glacier Deep Archive storage class, and S3 Intelligent-Tiering Archive or S3 Intelligent-Tiering Deep Archive tiers are not accessible in real time. For objects in Archive Access or Deep Archive Access tiers you must first initiate a restore request, and then wait until the object is moved into the Frequent Access tier. For objects in S3 Glacier or S3 Glacier Deep Archive storage classes you must first initiate a restore request, and then wait until a temporary copy of the object is available. To access an archived object, you must restore the object for the duration (number of days) that you specify. To restore a specific object version, you can provide a version ID. If you don't provide a version ID, Amazon S3 restores the current version. When restoring an archived object (or using a select request), you can specify one of the following data access tier options in the Tier element of the request body:      Expedited  - Expedited retrievals allow you to quickly access your data stored in the S3 Glacier storage class or S3 Intelligent-Tiering Archive tier when occasional urgent requests for a subset of archives are required. For all but the largest archived objects (250 MB+), data accessed using Expedited retrievals is typically made available within 1–5 minutes. Provisioned capacity ensures that retrieval capacity for Expedited retrievals is available when you need it. Expedited retrievals and provisioned capacity are not available for objects stored in the S3 Glacier Deep Archive storage class or S3 Intelligent-Tiering Deep Archive tier.     Standard  - Standard retrievals allow you to access any of your archived objects within several hours. This is the default option for retrieval requests that do not specify the retrieval option. Standard retrievals typically finish within 3–5 hours for objects stored in the S3 Glacier storage class or S3 Intelligent-Tiering Archive tier. They typically finish within 12 hours for objects stored in the S3 Glacier Deep Archive storage class or S3 Intelligent-Tiering Deep Archive tier. Standard retrievals are free for objects stored in S3 Intelligent-Tiering.     Bulk  - Bulk retrievals are the lowest-cost retrieval option in S3 Glacier, enabling you to retrieve large amounts, even petabytes, of data inexpensively. Bulk retrievals typically finish within 5–12 hours for objects stored in the S3 Glacier storage class or S3 Intelligent-Tiering Archive tier. They typically finish within 48 hours for objects stored in the S3 Glacier Deep Archive storage class or S3 Intelligent-Tiering Deep Archive tier. Bulk retrievals are free for objects stored in S3 Intelligent-Tiering.   For more information about archive retrieval options and provisioned capacity for Expedited data access, see Restoring Archived Objects in the Amazon S3 User Guide.  You can use Amazon S3 restore speed upgrade to change the restore speed to a faster speed while it is in progress. For more information, see  Upgrading the speed of an in-progress restore in the Amazon S3 User Guide.  To get the status of object restoration, you can send a HEAD request. Operations return the x-amz-restore header, which provides information about the restoration status, in the response. You can use Amazon S3 event notifications to notify you when a restore is initiated or completed. For more information, see Configuring Amazon S3 Event Notifications in the Amazon S3 User Guide. After restoring an archived object, you can update the restoration period by reissuing the request with a new period. Amazon S3 updates the restoration period relative to the current time and charges only for the request-there are no data transfer charges. You cannot update the restoration period when Amazon S3 is actively processing your current restore request for the object. If your bucket has a lifecycle configuration with a rule that includes an expiration action, the object expiration overrides the life span that you specify in a restore request. For example, if you restore an object copy for 10 days, but the object is scheduled to expire in 3 days, Amazon S3 deletes the object in 3 days. For more information about lifecycle configuration, see PutBucketLifecycleConfiguration and Object Lifecycle Management in Amazon S3 User Guide.  Responses  A successful action returns either the 200 OK or 202 Accepted status code.    If the object is not previously restored, then Amazon S3 returns 202 Accepted in the response.    If the object is previously restored, Amazon S3 returns 200 OK in the response.     Special Errors       Code: RestoreAlreadyInProgress     Cause: Object restore is already in progress. (This error does not apply to SELECT type requests.)     HTTP Status Code: 409 Conflict     SOAP Fault Code Prefix: Client         Code: GlacierExpeditedRetrievalNotAvailable     Cause: expedited retrievals are currently not available. Try again later. (Returned if there is insufficient capacity to process the Expedited request. This error applies only to Expedited retrievals and not to S3 Standard or Bulk retrievals.)     HTTP Status Code: 503     SOAP Fault Code Prefix: N/A       Related Resources     PutBucketLifecycleConfiguration     GetBucketNotificationConfiguration     SQL Reference for Amazon S3 Select and S3 Glacier Select  in the Amazon S3 User Guide

    Args:
        bucket(str): The bucket name containing the object to restore.  When using this action with an access point, you must direct requests to the access point hostname. The access point hostname takes the form AccessPointName-AccountId.s3-accesspoint.Region.amazonaws.com. When using this action with an access point through the AWS SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see Using access points in the Amazon S3 User Guide. When using this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com. When using this action using S3 on Outposts through the AWS SDKs, you provide the Outposts bucket ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see Using S3 on Outposts in the Amazon S3 User Guide.
        key(str): Object key for which the action was initiated.
        version_id(str, optional): VersionId used to reference a specific version of the object. Defaults to None.
        restore_request(Dict, optional): Container for restore job parameters. Defaults to None.
        request_payer(str, optional): Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. For information about downloading objects from requester pays buckets, see Downloading Objects in Requestor Pays Buckets in the Amazon S3 User Guide. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.init.restore(ctx, bucket=value, key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.init.restore bucket=value, key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="restore_object",
        op_kwargs={
            "Bucket": bucket,
            "Key": key,
            "VersionId": version_id,
            "RestoreRequest": restore_request,
            "RequestPayer": request_payer,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
