"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def select(
    hub,
    ctx,
    bucket: str,
    key: str,
    expression: str,
    expression_type: str,
    input_serialization: Dict,
    output_serialization: Dict,
    sse_customer_algorithm: str = None,
    sse_customer_key: str = None,
    sse_customer_key_md5: str = None,
    request_progress: Dict = None,
    scan_range: Dict = None,
    expected_bucket_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This action filters the contents of an Amazon S3 object based on a simple structured query language (SQL) statement. In the request, along with the SQL expression, you must also specify a data serialization format (JSON, CSV, or Apache Parquet) of the object. Amazon S3 uses this format to parse object data into records, and returns only records that match the specified SQL expression. You must also specify the data serialization format for the response. This action is not supported by Amazon S3 on Outposts. For more information about Amazon S3 Select, see Selecting Content from Objects in the Amazon S3 User Guide. For more information about using SQL with Amazon S3 Select, see  SQL Reference for Amazon S3 Select and S3 Glacier Select in the Amazon S3 User Guide.   Permissions  You must have s3:GetObject permission for this operation. Amazon S3 Select does not support anonymous access. For more information about permissions, see Specifying Permissions in a Policy in the Amazon S3 User Guide.   Object Data Formats  You can use Amazon S3 Select to query objects that have the following format properties:    CSV, JSON, and Parquet - Objects must be in CSV, JSON, or Parquet format.    UTF-8 - UTF-8 is the only encoding type Amazon S3 Select supports.    GZIP or BZIP2 - CSV and JSON files can be compressed using GZIP or BZIP2. GZIP and BZIP2 are the only compression formats that Amazon S3 Select supports for CSV and JSON files. Amazon S3 Select supports columnar compression for Parquet using GZIP or Snappy. Amazon S3 Select does not support whole-object compression for Parquet objects.    Server-side encryption - Amazon S3 Select supports querying objects that are protected with server-side encryption. For objects that are encrypted with customer-provided encryption keys (SSE-C), you must use HTTPS, and you must use the headers that are documented in the GetObject. For more information about SSE-C, see Server-Side Encryption (Using Customer-Provided Encryption Keys) in the Amazon S3 User Guide. For objects that are encrypted with Amazon S3 managed encryption keys (SSE-S3) and customer master keys (CMKs) stored in AWS Key Management Service (SSE-KMS), server-side encryption is handled transparently, so you don't need to specify anything. For more information about server-side encryption, including SSE-S3 and SSE-KMS, see Protecting Data Using Server-Side Encryption in the Amazon S3 User Guide.    Working with the Response Body  Given the response size is unknown, Amazon S3 Select streams the response as a series of messages and includes a Transfer-Encoding header with chunked as its value in the response. For more information, see Appendix: SelectObjectContent Response .   GetObject Support  The SelectObjectContent action does not support the following GetObject functionality. For more information, see GetObject.    Range: Although you can specify a scan range for an Amazon S3 Select request (see SelectObjectContentRequest - ScanRange in the request parameters), you cannot specify the range of bytes of an object to return.    GLACIER, DEEP_ARCHIVE and REDUCED_REDUNDANCY storage classes: You cannot specify the GLACIER, DEEP_ARCHIVE, or REDUCED_REDUNDANCY storage classes. For more information, about storage classes see Storage Classes in the Amazon S3 User Guide.     Special Errors  For a list of special errors for this operation, see List of SELECT Object Content Error Codes   Related Resources     GetObject     GetBucketLifecycleConfiguration     PutBucketLifecycleConfiguration

    Args:
        bucket(str): The S3 bucket.
        key(str): The object key.
        sse_customer_algorithm(str, optional): The SSE Algorithm used to encrypt the object. For more information, see Server-Side Encryption (Using Customer-Provided Encryption Keys. . Defaults to None.
        sse_customer_key(str, optional): The SSE Customer Key. For more information, see Server-Side Encryption (Using Customer-Provided Encryption Keys. . Defaults to None.
        sse_customer_key_md5(str, optional): The SSE Customer Key MD5. For more information, see Server-Side Encryption (Using Customer-Provided Encryption Keys. . Defaults to None.
        expression(str): The expression that is used to query the object.
        expression_type(str): The type of the provided expression (for example, SQL).
        request_progress(Dict, optional): Specifies if periodic request progress information should be enabled. Defaults to None.
        input_serialization(Dict): Describes the format of the data in the object that is being queried.
        output_serialization(Dict): Describes the format of the data that you want Amazon S3 to return in response.
        scan_range(Dict, optional): Specifies the byte range of the object to get the records from. A record is processed when its first byte is contained by the range. This parameter is optional, but when specified, it must not be empty. See RFC 2616, Section 14.35.1 about how to specify the start and end of the range.  ScanRangemay be used in the following ways:    <scanrange><start>50</start><end>100</end></scanrange> - process only the records starting between the bytes 50 and 100 (inclusive, counting from zero)    <scanrange><start>50</start></scanrange> - process only the records starting after the byte 50    <scanrange><end>50</end></scanrange> - process only the records within the last 50 bytes of the file.  . Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.object_.content.select(
                ctx,
                bucket=value,
                key=value,
                expression=value,
                expression_type=value,
                input_serialization=value,
                output_serialization=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.object_.content.select bucket=value, key=value, expression=value, expression_type=value, input_serialization=value, output_serialization=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="select_object_content",
        op_kwargs={
            "Bucket": bucket,
            "Key": key,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSECustomerKey": sse_customer_key,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "Expression": expression,
            "ExpressionType": expression_type,
            "RequestProgress": request_progress,
            "InputSerialization": input_serialization,
            "OutputSerialization": output_serialization,
            "ScanRange": scan_range,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
