"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def write(
    hub,
    ctx,
    request_route: str,
    request_token: str,
    body: bytes = None,
    status_code: int = None,
    error_code: str = None,
    error_message: str = None,
    accept_ranges: str = None,
    cache_control: str = None,
    content_disposition: str = None,
    content_encoding: str = None,
    content_language: str = None,
    content_length: int = None,
    content_range: str = None,
    content_type: str = None,
    delete_marker: bool = None,
    e_tag: str = None,
    expires: str = None,
    expiration: str = None,
    last_modified: str = None,
    missing_meta: int = None,
    metadata: Dict = None,
    object_lock_mode: str = None,
    object_lock_legal_hold_status: str = None,
    object_lock_retain_until_date: str = None,
    parts_count: int = None,
    replication_status: str = None,
    request_charged: str = None,
    restore: str = None,
    server_side_encryption: str = None,
    sse_customer_algorithm: str = None,
    ssekms_key_id: str = None,
    sse_customer_key_md5: str = None,
    storage_class: str = None,
    tag_count: int = None,
    version_id: str = None,
    bucket_key_enabled: bool = None,
) -> None:
    r"""
    **Autogenerated function**

    Passes transformed objects to a GetObject operation when using Object Lambda Access Points. For information about Object Lambda Access Points, see Transforming objects with Object Lambda Access Points in the Amazon S3 User Guide. This operation supports metadata that can be returned by GetObject, in addition to RequestRoute, RequestToken, StatusCode, ErrorCode, and ErrorMessage. The GetObject response metadata is supported so that the WriteGetObjectResponse caller, typically an AWS Lambda function, can provide the same metadata when it internally invokes GetObject. When WriteGetObjectResponse is called by a customer-owned Lambda function, the metadata returned to the end user GetObject call might differ from what Amazon S3 would normally return. AWS provides some prebuilt Lambda functions that you can use with S3 Object Lambda to detect and redact personally identifiable information (PII) and decompress S3 objects. These Lambda functions are available in the AWS Serverless Application Repository, and can be selected through the AWS Management Console when you create your Object Lambda Access Point. Example 1: PII Access Control - This Lambda function uses Amazon Comprehend, a natural language processing (NLP) service using machine learning to find insights and relationships in text. It automatically detects personally identifiable information (PII) such as names, addresses, dates, credit card numbers, and social security numbers from documents in your Amazon S3 bucket.  Example 2: PII Redaction - This Lambda function uses Amazon Comprehend, a natural language processing (NLP) service using machine learning to find insights and relationships in text. It automatically redacts personally identifiable information (PII) such as names, addresses, dates, credit card numbers, and social security numbers from documents in your Amazon S3 bucket.  Example 3: Decompression - The Lambda function S3ObjectLambdaDecompression, is equipped to decompress objects stored in S3 in one of six compressed file formats including bzip2, gzip, snappy, zlib, zstandard and ZIP.  For information on how to view and use these functions, see Using AWS built Lambda functions in the Amazon S3 User Guide.

    Args:
        request_route(str): Route prefix to the HTTP URL generated.
        request_token(str): A single use encrypted token that maps WriteGetObjectResponse to the end user GetObject request.
        body(bytes, optional): The object data. Defaults to None.
        status_code(int, optional): The integer status code for an HTTP response of a corresponding GetObject request.  Status Codes     200 - OK     206 - Partial Content     304 - Not Modified     400 - Bad Request     401 - Unauthorized     403 - Forbidden     404 - Not Found     405 - Method Not Allowed     409 - Conflict     411 - Length Required     412 - Precondition Failed     416 - Range Not Satisfiable     500 - Internal Server Error     503 - Service Unavailable   . Defaults to None.
        error_code(str, optional): A string that uniquely identifies an error condition. Returned in the <Code> tag of the error XML response for a corresponding GetObject call. Cannot be used with a successful StatusCode header or when the transformed object is provided in the body. All error codes from S3 are sentence-cased. Regex value is "^[A-Z][a-zA-Z]+$". Defaults to None.
        error_message(str, optional): Contains a generic description of the error condition. Returned in the <Message> tag of the error XML response for a corresponding GetObject call. Cannot be used with a successful StatusCode header or when the transformed object is provided in body. Defaults to None.
        accept_ranges(str, optional): Indicates that a range of bytes was specified. Defaults to None.
        cache_control(str, optional): Specifies caching behavior along the request/reply chain. Defaults to None.
        content_disposition(str, optional): Specifies presentational information for the object. Defaults to None.
        content_encoding(str, optional): Specifies what content encodings have been applied to the object and thus what decoding mechanisms must be applied to obtain the media-type referenced by the Content-Type header field. Defaults to None.
        content_language(str, optional): The language the content is in. Defaults to None.
        content_length(int, optional): The size of the content body in bytes. Defaults to None.
        content_range(str, optional): The portion of the object returned in the response. Defaults to None.
        content_type(str, optional): A standard MIME type describing the format of the object data. Defaults to None.
        delete_marker(bool, optional): Specifies whether an object stored in Amazon S3 is (true) or is not (false) a delete marker. . Defaults to None.
        e_tag(str, optional): An opaque identifier assigned by a web server to a specific version of a resource found at a URL. . Defaults to None.
        expires(str, optional): The date and time at which the object is no longer cacheable. Defaults to None.
        expiration(str, optional): If object stored in Amazon S3 expiration is configured (see PUT Bucket lifecycle) it includes expiry-date and rule-id key-value pairs providing object expiration information. The value of the rule-id is URL encoded. . Defaults to None.
        last_modified(str, optional): The date and time that the object was last modified. Defaults to None.
        missing_meta(int, optional): Set to the number of metadata entries not returned in x-amz-meta headers. This can happen if you create metadata using an API like SOAP that supports more flexible metadata than the REST API. For example, using SOAP, you can create metadata whose values are not legal HTTP headers. Defaults to None.
        metadata(Dict, optional): A map of metadata to store with the object in S3. Defaults to None.
        object_lock_mode(str, optional): Indicates whether an object stored in Amazon S3 has Object Lock enabled. For more information about S3 Object Lock, see Object Lock. Defaults to None.
        object_lock_legal_hold_status(str, optional): Indicates whether an object stored in Amazon S3 has an active legal hold. Defaults to None.
        object_lock_retain_until_date(str, optional): The date and time when Object Lock is configured to expire. Defaults to None.
        parts_count(int, optional): The count of parts this object has. Defaults to None.
        replication_status(str, optional): Indicates if request involves bucket that is either a source or destination in a Replication rule. For more information about S3 Replication, see Replication. Defaults to None.
        request_charged(str, optional): If present, indicates that the requester was successfully charged for the request. Defaults to None.
        restore(str, optional): Provides information about object restoration operation and expiration time of the restored object copy. Defaults to None.
        server_side_encryption(str, optional):  The server-side encryption algorithm used when storing requested object in Amazon S3 (for example, AES256, aws:kms). Defaults to None.
        sse_customer_algorithm(str, optional): Encryption algorithm used if server-side encryption with a customer-provided encryption key was specified for object stored in Amazon S3. Defaults to None.
        ssekms_key_id(str, optional):  If present, specifies the ID of the AWS Key Management Service (AWS KMS) symmetric customer managed customer master key (CMK) that was used for stored in Amazon S3 object. . Defaults to None.
        sse_customer_key_md5(str, optional):  128-bit MD5 digest of customer-provided encryption key used in Amazon S3 to encrypt data stored in S3. For more information, see Protecting data using server-side encryption with customer-provided encryption keys (SSE-C). Defaults to None.
        storage_class(str, optional):  The class of storage used to store object in Amazon S3. Defaults to None.
        tag_count(int, optional): The number of tags, if any, on the object. Defaults to None.
        version_id(str, optional): An ID used to reference a specific version of the object. Defaults to None.
        bucket_key_enabled(bool, optional):  Indicates whether the object stored in Amazon S3 uses an S3 bucket key for server-side encryption with AWS KMS (SSE-KMS). Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.get_object_response.write(
                ctx, request_route=value, request_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.get_object_response.write request_route=value, request_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="write_get_object_response",
        op_kwargs={
            "RequestRoute": request_route,
            "RequestToken": request_token,
            "Body": body,
            "StatusCode": status_code,
            "ErrorCode": error_code,
            "ErrorMessage": error_message,
            "AcceptRanges": accept_ranges,
            "CacheControl": cache_control,
            "ContentDisposition": content_disposition,
            "ContentEncoding": content_encoding,
            "ContentLanguage": content_language,
            "ContentLength": content_length,
            "ContentRange": content_range,
            "ContentType": content_type,
            "DeleteMarker": delete_marker,
            "ETag": e_tag,
            "Expires": expires,
            "Expiration": expiration,
            "LastModified": last_modified,
            "MissingMeta": missing_meta,
            "Metadata": metadata,
            "ObjectLockMode": object_lock_mode,
            "ObjectLockLegalHoldStatus": object_lock_legal_hold_status,
            "ObjectLockRetainUntilDate": object_lock_retain_until_date,
            "PartsCount": parts_count,
            "ReplicationStatus": replication_status,
            "RequestCharged": request_charged,
            "Restore": restore,
            "ServerSideEncryption": server_side_encryption,
            "SSECustomerAlgorithm": sse_customer_algorithm,
            "SSEKMSKeyId": ssekms_key_id,
            "SSECustomerKeyMD5": sse_customer_key_md5,
            "StorageClass": storage_class,
            "TagCount": tag_count,
            "VersionId": version_id,
            "BucketKeyEnabled": bucket_key_enabled,
        },
    )
