"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete_multiple(
    hub, ctx, bucket: str, expected_bucket_owner: str = None
) -> None:
    r"""
    **Autogenerated function**

    Removes OwnershipControls for an Amazon S3 bucket. To use this operation, you must have the s3:PutBucketOwnershipControls permission. For more information about Amazon S3 permissions, see Specifying Permissions in a Policy. For information about Amazon S3 Object Ownership, see Using Object Ownership.  The following operations are related to DeleteBucketOwnershipControls:    GetBucketOwnershipControls     PutBucketOwnershipControls

    Args:
        bucket(str): The Amazon S3 bucket whose OwnershipControls you want to delete. .
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.ownership_control.delete_multiple(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.ownership_control.delete_multiple bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="delete_bucket_ownership_controls",
        op_kwargs={"Bucket": bucket, "ExpectedBucketOwner": expected_bucket_owner},
    )


async def get_all(hub, ctx, bucket: str, expected_bucket_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves OwnershipControls for an Amazon S3 bucket. To use this operation, you must have the s3:GetBucketOwnershipControls permission. For more information about Amazon S3 permissions, see Specifying Permissions in a Policy.  For information about Amazon S3 Object Ownership, see Using Object Ownership.  The following operations are related to GetBucketOwnershipControls:    PutBucketOwnershipControls     DeleteBucketOwnershipControls

    Args:
        bucket(str): The name of the Amazon S3 bucket whose OwnershipControls you want to retrieve. .
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.ownership_control.get_all(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.ownership_control.get_all bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_bucket_ownership_controls",
        op_kwargs={"Bucket": bucket, "ExpectedBucketOwner": expected_bucket_owner},
    )


async def put_multiple(
    hub,
    ctx,
    bucket: str,
    ownership_controls: Dict,
    content_md5: str = None,
    expected_bucket_owner: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates or modifies OwnershipControls for an Amazon S3 bucket. To use this operation, you must have the s3:PutBucketOwnershipControls permission. For more information about Amazon S3 permissions, see Specifying Permissions in a Policy.  For information about Amazon S3 Object Ownership, see Using Object Ownership.  The following operations are related to PutBucketOwnershipControls:    GetBucketOwnershipControls     DeleteBucketOwnershipControls

    Args:
        bucket(str): The name of the Amazon S3 bucket whose OwnershipControls you want to set.
        content_md5(str, optional): The MD5 hash of the OwnershipControls request body.  For requests made using the AWS Command Line Interface (CLI) or AWS SDKs, this field is calculated automatically. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.
        ownership_controls(Dict): The OwnershipControls (BucketOwnerPreferred or ObjectWriter) that you want to apply to this Amazon S3 bucket.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.ownership_control.put_multiple(
                ctx, bucket=value, ownership_controls=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.ownership_control.put_multiple bucket=value, ownership_controls=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="put_bucket_ownership_controls",
        op_kwargs={
            "Bucket": bucket,
            "ContentMD5": content_md5,
            "ExpectedBucketOwner": expected_bucket_owner,
            "OwnershipControls": ownership_controls,
        },
    )
