"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, bucket: str, expected_bucket_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET, you must be the bucket owner. The following operations are related to GetBucketLogging:    CreateBucket     PutBucketLogging

    Args:
        bucket(str): The bucket name for which to get the logging information.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.logging.get(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.logging.get bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_bucket_logging",
        op_kwargs={"Bucket": bucket, "ExpectedBucketOwner": expected_bucket_owner},
    )


async def put(
    hub,
    ctx,
    bucket: str,
    bucket_logging_status: Dict,
    content_md5: str = None,
    expected_bucket_owner: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging parameters. All logs are saved to buckets in the same AWS Region as the source bucket. To set the logging status of a bucket, you must be the bucket owner. The bucket owner is automatically granted FULL_CONTROL to all logs. You use the Grantee request element to grant access to other people. The Permissions request element specifies the kind of access the grantee has to the logs.  Grantee Values  You can specify the person (grantee) to whom you're assigning access rights (using request elements) in the following ways:   By the person's ID:  <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="CanonicalUser"><ID><>ID<></ID><DisplayName><>GranteesEmail<></DisplayName> </Grantee>  DisplayName is optional and ignored in the request.   By Email address:   <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="AmazonCustomerByEmail"><EmailAddress><>Grantees@email.com<></EmailAddress></Grantee>  The grantee is resolved to the CanonicalUser and, in a response to a GET Object acl request, appears as the CanonicalUser.   By URI:  <Grantee xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:type="Group"><URI><>http://acs.amazonaws.com/groups/global/AuthenticatedUsers<></URI></Grantee>    To enable logging, you use LoggingEnabled and its children request elements. To disable logging, you use an empty BucketLoggingStatus request element:  <BucketLoggingStatus xmlns="http://doc.s3.amazonaws.com/2006-03-01" />  For more information about server access logging, see Server Access Logging.  For more information about creating a bucket, see CreateBucket. For more information about returning the logging status of a bucket, see GetBucketLogging. The following operations are related to PutBucketLogging:    PutObject     DeleteBucket     CreateBucket     GetBucketLogging

    Args:
        bucket(str): The name of the bucket for which to set the logging parameters.
        bucket_logging_status(Dict): Container for logging status information.
        content_md5(str, optional): The MD5 hash of the PutBucketLogging request body. For requests made using the AWS Command Line Interface (CLI) or AWS SDKs, this field is calculated automatically. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.logging.put(
                ctx, bucket=value, bucket_logging_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.logging.put bucket=value, bucket_logging_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="put_bucket_logging",
        op_kwargs={
            "Bucket": bucket,
            "BucketLoggingStatus": bucket_logging_status,
            "ContentMD5": content_md5,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
