"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, bucket: str, expected_bucket_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the Region the bucket resides in. You set the bucket's Region using the LocationConstraint request parameter in a CreateBucket request. For more information, see CreateBucket.  To use this implementation of the operation, you must be the bucket owner. The following operations are related to GetBucketLocation:    GetObject     CreateBucket

    Args:
        bucket(str): The name of the bucket for which to get the location.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.location.get(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.location.get bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_bucket_location",
        op_kwargs={"Bucket": bucket, "ExpectedBucketOwner": expected_bucket_owner},
    )
