"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, bucket: str, expected_bucket_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The response describes the new filter element that you can use to specify a filter to select a subset of objects to which the rule applies. If you are using a previous version of the lifecycle configuration, it still works. For the earlier action, see GetBucketLifecycle.  Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration, see Object Lifecycle Management. To use this operation, you must have permission to perform the s3:GetLifecycleConfiguration action. The bucket owner has this permission, by default. The bucket owner can grant this permission to others. For more information about permissions, see Permissions Related to Bucket Subresource Operations and Managing Access Permissions to Your Amazon S3 Resources.  GetBucketLifecycleConfiguration has the following special error:   Error code: NoSuchLifecycleConfiguration    Description: The lifecycle configuration does not exist.   HTTP Status Code: 404 Not Found   SOAP Fault Code Prefix: Client     The following operations are related to GetBucketLifecycleConfiguration:    GetBucketLifecycle     PutBucketLifecycle     DeleteBucketLifecycle

    Args:
        bucket(str): The name of the bucket for which to get the lifecycle information.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.lifecycle.configuration.get(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.lifecycle.configuration.get bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="get_bucket_lifecycle_configuration",
        op_kwargs={"Bucket": bucket, "ExpectedBucketOwner": expected_bucket_owner},
    )


async def put(
    hub,
    ctx,
    bucket: str,
    lifecycle_configuration: Dict = None,
    expected_bucket_owner: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. For information about lifecycle configuration, see Managing your storage lifecycle.  Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The previous version of the API supported filtering based only on an object key name prefix, which is supported for backward compatibility. For the related API description, see PutBucketLifecycle.   Rules  You specify the lifecycle configuration in your request body. The lifecycle configuration is specified as XML consisting of one or more rules. Each rule consists of the following:   Filter identifying a subset of objects to which the rule applies. The filter can be based on a key name prefix, object tags, or a combination of both.   Status whether the rule is in effect.   One or more lifecycle transition and expiration actions that you want Amazon S3 to perform on the objects identified by the filter. If the state of your bucket is versioning-enabled or versioning-suspended, you can have many versions of the same object (one current version and zero or more noncurrent versions). Amazon S3 provides predefined actions that you can specify for current and noncurrent object versions.   For more information, see Object Lifecycle Management and Lifecycle Configuration Elements.  Permissions  By default, all Amazon S3 resources are private, including buckets, objects, and related subresources (for example, lifecycle configuration and website configuration). Only the resource owner (that is, the AWS account that created it) can access the resource. The resource owner can optionally grant access permissions to others by writing an access policy. For this operation, a user must get the s3:PutLifecycleConfiguration permission. You can also explicitly deny permissions. Explicit deny also supersedes any other permissions. If you want to block users or accounts from removing or deleting objects from your bucket, you must deny them permissions for the following actions:   s3:DeleteObject   s3:DeleteObjectVersion   s3:PutLifecycleConfiguration   For more information about permissions, see Managing Access Permissions to Your Amazon S3 Resources. The following are related to PutBucketLifecycleConfiguration:    Examples of Lifecycle Configuration     GetBucketLifecycleConfiguration     DeleteBucketLifecycle

    Args:
        bucket(str): The name of the bucket for which to set the configuration.
        lifecycle_configuration(Dict, optional): Container for lifecycle rules. You can add as many as 1,000 rules. Defaults to None.
        expected_bucket_owner(str, optional): The account ID of the expected bucket owner. If the bucket is owned by a different account, the request will fail with an HTTP 403 (Access Denied) error. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.s3.bucket.lifecycle.configuration.put(ctx, bucket=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.s3.bucket.lifecycle.configuration.put bucket=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="s3",
        operation="put_bucket_lifecycle_configuration",
        op_kwargs={
            "Bucket": bucket,
            "LifecycleConfiguration": lifecycle_configuration,
            "ExpectedBucketOwner": expected_bucket_owner,
        },
    )
