"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the Resolver rule policy for a specified rule. A Resolver rule policy includes the rule that you want to share with another account, the account that you want to share the rule with, and the Resolver operations that you want to allow the account to use.

    Args:
        arn(str): The ID of the Resolver rule that you want to get the Resolver rule policy for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.rule.policy.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.rule.policy.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_resolver_rule_policy",
        op_kwargs={"Arn": arn},
    )


async def put(hub, ctx, arn: str, resolver_rule_policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Specifies an AWS rule that you want to share with another account, the account that you want to share the rule with, and the operations that you want the account to be able to perform on the rule.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the rule that you want to share with another account.
        resolver_rule_policy(str): An AWS Identity and Access Management policy statement that lists the rules that you want to share with another AWS account and the operations that you want the account to be able to perform. You can specify the following operations in the Action section of the statement:    route53resolver:GetResolverRule     route53resolver:AssociateResolverRule     route53resolver:DisassociateResolverRule     route53resolver:ListResolverRules     route53resolver:ListResolverRuleAssociations    In the Resource section of the statement, specify the ARN for the rule that you want to share with another account. Specify the same ARN that you specified in Arn.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.rule.policy.put(
                ctx, arn=value, resolver_rule_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.rule.policy.put arn=value, resolver_rule_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="put_resolver_rule_policy",
        op_kwargs={"Arn": arn, "ResolverRulePolicy": resolver_rule_policy},
    )
