"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, resolver_rule_association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about an association between a specified Resolver rule and a VPC. You associate a Resolver rule and a VPC using AssociateResolverRule.

    Args:
        resolver_rule_association_id(str): The ID of the Resolver rule association that you want to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.rule.association.get(
                ctx, resolver_rule_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.rule.association.get resolver_rule_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_resolver_rule_association",
        op_kwargs={"ResolverRuleAssociationId": resolver_rule_association_id},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the associations that were created between Resolver rules and VPCs using the current AWS account.

    Args:
        max_results(int, optional): The maximum number of rule associations that you want to return in the response to a ListResolverRuleAssociations request. If you don't specify a value for MaxResults, Resolver returns up to 100 rule associations. . Defaults to None.
        next_token(str, optional): For the first ListResolverRuleAssociation request, omit this value. If you have more than MaxResults rule associations, you can submit another ListResolverRuleAssociation request to get the next group of rule associations. In the next request, specify the value of NextToken from the previous response. . Defaults to None.
        filters(List, optional): An optional specification to return a subset of Resolver rules, such as Resolver rules that are associated with the same VPC ID.  If you submit a second or subsequent ListResolverRuleAssociations request and specify the NextToken parameter, you must use the same values for Filters, if any, as in the previous request. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.rule.association.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.rule.association.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_resolver_rule_associations",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )
