"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a query logging policy. A query logging policy specifies the Resolver query logging operations and resources that you want to allow another AWS account to be able to use.

    Args:
        arn(str): The ARN of the query logging configuration that you want to get the query logging policy for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.query_log_config.policy.get(
                ctx, arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.query_log_config.policy.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_resolver_query_log_config_policy",
        op_kwargs={"Arn": arn},
    )


async def put(hub, ctx, arn: str, resolver_query_log_config_policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Specifies an AWS account that you want to share a query logging configuration with, the query logging configuration that you want to share, and the operations that you want the account to be able to perform on the configuration.

    Args:
        arn(str): The Amazon Resource Name (ARN) of the account that you want to share rules with.
        resolver_query_log_config_policy(str): An AWS Identity and Access Management policy statement that lists the query logging configurations that you want to share with another AWS account and the operations that you want the account to be able to perform. You can specify the following operations in the Actions section of the statement:    route53resolver:AssociateResolverQueryLogConfig     route53resolver:DisassociateResolverQueryLogConfig     route53resolver:ListResolverQueryLogConfigAssociations     route53resolver:ListResolverQueryLogConfigs    In the Resource section of the statement, you specify the ARNs for the query logging configurations that you want to share with the account that you specified in Arn. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.query_log_config.policy.put(
                ctx, arn=value, resolver_query_log_config_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.query_log_config.policy.put arn=value, resolver_query_log_config_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="put_resolver_query_log_config_policy",
        op_kwargs={
            "Arn": arn,
            "ResolverQueryLogConfigPolicy": resolver_query_log_config_policy,
        },
    )
