"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx, resolver_endpoint_id: str, ip_address: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds IP addresses to an inbound or an outbound Resolver endpoint. If you want to add more than one IP address, submit one AssociateResolverEndpointIpAddress request for each IP address. To remove an IP address from an endpoint, see DisassociateResolverEndpointIpAddress.

    Args:
        resolver_endpoint_id(str): The ID of the Resolver endpoint that you want to associate IP addresses with.
        ip_address(Dict): Either the IPv4 address that you want to add to a Resolver endpoint or a subnet ID. If you specify a subnet ID, Resolver chooses an IP address for you from the available IPs in the specified subnet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.endpoint.ip_address.associate(
                ctx, resolver_endpoint_id=value, ip_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.endpoint.ip_address.associate resolver_endpoint_id=value, ip_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="associate_resolver_endpoint_ip_address",
        op_kwargs={"ResolverEndpointId": resolver_endpoint_id, "IpAddress": ip_address},
    )


async def disassociate(hub, ctx, resolver_endpoint_id: str, ip_address: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Removes IP addresses from an inbound or an outbound Resolver endpoint. If you want to remove more than one IP address, submit one DisassociateResolverEndpointIpAddress request for each IP address. To add an IP address to an endpoint, see AssociateResolverEndpointIpAddress.

    Args:
        resolver_endpoint_id(str): The ID of the Resolver endpoint that you want to disassociate an IP address from.
        ip_address(Dict): The IPv4 address that you want to remove from a Resolver endpoint.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.endpoint.ip_address.disassociate(
                ctx, resolver_endpoint_id=value, ip_address=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.endpoint.ip_address.disassociate resolver_endpoint_id=value, ip_address=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="disassociate_resolver_endpoint_ip_address",
        op_kwargs={"ResolverEndpointId": resolver_endpoint_id, "IpAddress": ip_address},
    )


async def list_all(
    hub, ctx, resolver_endpoint_id: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the IP addresses for a specified Resolver endpoint.

    Args:
        resolver_endpoint_id(str): The ID of the Resolver endpoint that you want to get IP addresses for.
        max_results(int, optional): The maximum number of IP addresses that you want to return in the response to a ListResolverEndpointIpAddresses request. If you don't specify a value for MaxResults, Resolver returns up to 100 IP addresses. . Defaults to None.
        next_token(str, optional): For the first ListResolverEndpointIpAddresses request, omit this value. If the specified Resolver endpoint has more than MaxResults IP addresses, you can submit another ListResolverEndpointIpAddresses request to get the next group of IP addresses. In the next request, specify the value of NextToken from the previous response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.endpoint.ip_address.list_all(
                ctx, resolver_endpoint_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.endpoint.ip_address.list_all resolver_endpoint_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_resolver_endpoint_ip_addresses",
        op_kwargs={
            "ResolverEndpointId": resolver_endpoint_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
