"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets DNSSEC validation information for a specified resource.

    Args:
        resource_id(str): The ID of the virtual private cloud (VPC) for the DNSSEC validation status.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.dnssec_config.get(
                ctx, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.dnssec_config.get resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_resolver_dnssec_config",
        op_kwargs={"ResourceId": resource_id},
    )


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, filters: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the configurations for DNSSEC validation that are associated with the current AWS account.

    Args:
        max_results(int, optional):  Optional: An integer that specifies the maximum number of DNSSEC configuration results that you want Amazon Route 53 to return. If you don't specify a value for MaxResults, Route 53 returns up to 100 configuration per page. Defaults to None.
        next_token(str, optional): (Optional) If the current AWS account has more than MaxResults DNSSEC configurations, use NextToken to get the second and subsequent pages of results. For the first ListResolverDnssecConfigs request, omit this value. For the second and subsequent requests, get the value of NextToken from the previous response and specify that value for NextToken in the request. Defaults to None.
        filters(List, optional): An optional specification to return a subset of objects. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.dnssec_config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.dnssec_config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_resolver_dnssec_configs",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "Filters": filters,
        },
    )


async def update(hub, ctx, resource_id: str, validation: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing DNSSEC validation configuration. If there is no existing DNSSEC validation configuration, one is created.

    Args:
        resource_id(str): The ID of the virtual private cloud (VPC) that you're updating the DNSSEC validation status for.
        validation(str): The new value that you are specifying for DNSSEC validation for the VPC. The value can be ENABLE or DISABLE. Be aware that it can take time for a validation status change to be completed.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.resolver.dnssec_config.update(
                ctx, resource_id=value, validation=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.resolver.dnssec_config.update resource_id=value, validation=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="update_resolver_dnssec_config",
        op_kwargs={"ResourceId": resource_id, "Validation": validation},
    )
