"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    creator_request_id: str,
    firewall_rule_group_id: str,
    firewall_domain_list_id: str,
    priority: int,
    action: str,
    name: str,
    block_response: str = None,
    block_override_domain: str = None,
    block_override_dns_type: str = None,
    block_override_ttl: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a single DNS Firewall rule in the specified rule group, using the specified domain list.

    Args:
        creator_request_id(str): A unique string that identifies the request and that allows you to retry failed requests without the risk of running the operation twice. CreatorRequestId can be any unique string, for example, a date/time stamp. .
        firewall_rule_group_id(str): The unique identifier of the firewall rule group where you want to create the rule. .
        firewall_domain_list_id(str): The ID of the domain list that you want to use in the rule. .
        priority(int): The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting. You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time.
        action(str): The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:    ALLOW - Permit the request to go through.    ALERT - Permit the request and send metrics and logs to Cloud Watch.    BLOCK - Disallow the request. This option requires additional details in the rule's BlockResponse.   .
        block_response(str, optional): The way that you want DNS Firewall to block the request, used with the rule action setting BLOCK.     NODATA - Respond indicating that the query was successful, but no response is available for it.    NXDOMAIN - Respond indicating that the domain name that's in the query doesn't exist.    OVERRIDE - Provide a custom override in the response. This option requires custom handling details in the rule's BlockOverride* settings.    This setting is required if the rule action setting is BLOCK. Defaults to None.
        block_override_domain(str, optional): The custom DNS record to send back in response to the query. Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. This setting is required if the BlockResponse setting is OVERRIDE. Defaults to None.
        block_override_dns_type(str, optional): The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. This setting is required if the BlockResponse setting is OVERRIDE. Defaults to None.
        block_override_ttl(int, optional): The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. This setting is required if the BlockResponse setting is OVERRIDE. Defaults to None.
        name(str): A name that lets you identify the rule in the rule group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.init.create(
                ctx,
                creator_request_id=value,
                firewall_rule_group_id=value,
                firewall_domain_list_id=value,
                priority=value,
                action=value,
                name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.init.create creator_request_id=value, firewall_rule_group_id=value, firewall_domain_list_id=value, priority=value, action=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="create_firewall_rule",
        op_kwargs={
            "CreatorRequestId": creator_request_id,
            "FirewallRuleGroupId": firewall_rule_group_id,
            "FirewallDomainListId": firewall_domain_list_id,
            "Priority": priority,
            "Action": action,
            "BlockResponse": block_response,
            "BlockOverrideDomain": block_override_domain,
            "BlockOverrideDnsType": block_override_dns_type,
            "BlockOverrideTtl": block_override_ttl,
            "Name": name,
        },
    )


async def delete(
    hub, ctx, firewall_rule_group_id: str, firewall_domain_list_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified firewall rule.

    Args:
        firewall_rule_group_id(str): The unique identifier of the firewall rule group that you want to delete the rule from. .
        firewall_domain_list_id(str): The ID of the domain list that's used in the rule. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.init.delete(
                ctx, firewall_rule_group_id=value, firewall_domain_list_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.init.delete firewall_rule_group_id=value, firewall_domain_list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="delete_firewall_rule",
        op_kwargs={
            "FirewallRuleGroupId": firewall_rule_group_id,
            "FirewallDomainListId": firewall_domain_list_id,
        },
    )


async def list_all(
    hub,
    ctx,
    firewall_rule_group_id: str,
    priority: int = None,
    action: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the firewall rules that you have defined for the specified firewall rule group. DNS Firewall uses the rules in a rule group to filter DNS network traffic for a VPC.  A single call might return only a partial list of the rules. For information, see MaxResults.

    Args:
        firewall_rule_group_id(str): The unique identifier of the firewall rule group that you want to retrieve the rules for. .
        priority(int, optional): Optional additional filter for the rules to retrieve. The setting that determines the processing order of the rules in a rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting. Defaults to None.
        action(str, optional): Optional additional filter for the rules to retrieve. The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:    ALLOW - Permit the request to go through.    ALERT - Permit the request to go through but send an alert to the logs.    BLOCK - Disallow the request. If this is specified, additional handling details are provided in the rule's BlockResponse setting.   . Defaults to None.
        max_results(int, optional): The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a NextToken value that you can use in a subsequent call to get the next batch of objects. If you don't specify a value for MaxResults, Resolver returns up to 100 objects. . Defaults to None.
        next_token(str, optional): For the first call to this list request, omit this value. When you request a list of objects, Resolver returns at most the number of objects specified in MaxResults. If more objects are available for retrieval, Resolver returns a NextToken value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.init.list_all(
                ctx, firewall_rule_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.init.list_all firewall_rule_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_firewall_rules",
        op_kwargs={
            "FirewallRuleGroupId": firewall_rule_group_id,
            "Priority": priority,
            "Action": action,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    firewall_rule_group_id: str,
    firewall_domain_list_id: str,
    priority: int = None,
    action: str = None,
    block_response: str = None,
    block_override_domain: str = None,
    block_override_dns_type: str = None,
    block_override_ttl: int = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified firewall rule.

    Args:
        firewall_rule_group_id(str): The unique identifier of the firewall rule group for the rule. .
        firewall_domain_list_id(str): The ID of the domain list to use in the rule. .
        priority(int, optional): The setting that determines the processing order of the rule in the rule group. DNS Firewall processes the rules in a rule group by order of priority, starting from the lowest setting. You must specify a unique priority for each rule in a rule group. To make it easier to insert rules later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for the rules in a rule group at any time. Defaults to None.
        action(str, optional): The action that DNS Firewall should take on a DNS query when it matches one of the domains in the rule's domain list:    ALLOW - Permit the request to go through.    ALERT - Permit the request to go through but send an alert to the logs.    BLOCK - Disallow the request. This option requires additional details in the rule's BlockResponse.   . Defaults to None.
        block_response(str, optional): The way that you want DNS Firewall to block the request. Used for the rule action setting BLOCK.    NODATA - Respond indicating that the query was successful, but no response is available for it.    NXDOMAIN - Respond indicating that the domain name that's in the query doesn't exist.    OVERRIDE - Provide a custom override in the response. This option requires custom handling details in the rule's BlockOverride* settings.   . Defaults to None.
        block_override_domain(str, optional): The custom DNS record to send back in response to the query. Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. Defaults to None.
        block_override_dns_type(str, optional): The DNS record's type. This determines the format of the record value that you provided in BlockOverrideDomain. Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. Defaults to None.
        block_override_ttl(int, optional): The recommended amount of time, in seconds, for the DNS resolver or web browser to cache the provided override record. Used for the rule action BLOCK with a BlockResponse setting of OVERRIDE. Defaults to None.
        name(str, optional): The name of the rule. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.init.update(
                ctx, firewall_rule_group_id=value, firewall_domain_list_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.init.update firewall_rule_group_id=value, firewall_domain_list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="update_firewall_rule",
        op_kwargs={
            "FirewallRuleGroupId": firewall_rule_group_id,
            "FirewallDomainListId": firewall_domain_list_id,
            "Priority": priority,
            "Action": action,
            "BlockResponse": block_response,
            "BlockOverrideDomain": block_override_domain,
            "BlockOverrideDnsType": block_override_dns_type,
            "BlockOverrideTtl": block_override_ttl,
            "Name": name,
        },
    )
