"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the AWS Identity and Access Management (AWS IAM) policy for sharing the specified rule group. You can use the policy to share the rule group using AWS Resource Access Manager (AWS RAM).

    Args:
        arn(str): The ARN (Amazon Resource Name) for the rule group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.policy.get(ctx, arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.policy.get arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_firewall_rule_group_policy",
        op_kwargs={"Arn": arn},
    )


async def put(hub, ctx, arn: str, firewall_rule_group_policy: str) -> Dict:
    r"""
    **Autogenerated function**

    Attaches an AWS Identity and Access Management (AWS IAM) policy for sharing the rule group. You can use the policy to share the rule group using AWS Resource Access Manager (AWS RAM).

    Args:
        arn(str): The ARN (Amazon Resource Name) for the rule group that you want to share.
        firewall_rule_group_policy(str): The AWS Identity and Access Management (AWS IAM) policy to attach to the rule group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.policy.put(
                ctx, arn=value, firewall_rule_group_policy=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.policy.put arn=value, firewall_rule_group_policy=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="put_firewall_rule_group_policy",
        op_kwargs={"Arn": arn, "FirewallRuleGroupPolicy": firewall_rule_group_policy},
    )
