"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def associate(
    hub,
    ctx,
    creator_request_id: str,
    firewall_rule_group_id: str,
    vpc_id: str,
    priority: int,
    name: str,
    mutation_protection: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates a FirewallRuleGroup with a VPC, to provide DNS filtering for the VPC.

    Args:
        creator_request_id(str): A unique string that identifies the request and that allows failed requests to be retried without the risk of running the operation twice. CreatorRequestId can be any unique string, for example, a date/time stamp. .
        firewall_rule_group_id(str): The unique identifier of the firewall rule group. .
        vpc_id(str): The unique identifier of the VPC that you want to associate with the rule group. .
        priority(int): The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.  You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it. The allowed values for Priority are between 100 and 9900.
        name(str): A name that lets you identify the association, to manage and use it.
        mutation_protection(str, optional): If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. When you create the association, the default setting is DISABLED. . Defaults to None.
        tags(List, optional): A list of the tag keys and values that you want to associate with the rule group association. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.init.associate(
                ctx,
                creator_request_id=value,
                firewall_rule_group_id=value,
                vpc_id=value,
                priority=value,
                name=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.init.associate creator_request_id=value, firewall_rule_group_id=value, vpc_id=value, priority=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="associate_firewall_rule_group",
        op_kwargs={
            "CreatorRequestId": creator_request_id,
            "FirewallRuleGroupId": firewall_rule_group_id,
            "VpcId": vpc_id,
            "Priority": priority,
            "Name": name,
            "MutationProtection": mutation_protection,
            "Tags": tags,
        },
    )


async def create(
    hub, ctx, creator_request_id: str, name: str, tags: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an empty DNS Firewall rule group for filtering DNS network traffic in a VPC. You can add rules to the new rule group by calling CreateFirewallRule.

    Args:
        creator_request_id(str): A unique string defined by you to identify the request. This allows you to retry failed requests without the risk of running the operation twice. This can be any unique string, for example, a timestamp. .
        name(str): A name that lets you identify the rule group, to manage and use it.
        tags(List, optional): A list of the tag keys and values that you want to associate with the rule group. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.init.create(
                ctx, creator_request_id=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.init.create creator_request_id=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="create_firewall_rule_group",
        op_kwargs={"CreatorRequestId": creator_request_id, "Name": name, "Tags": tags},
    )


async def delete(hub, ctx, firewall_rule_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified firewall rule group.

    Args:
        firewall_rule_group_id(str): The unique identifier of the firewall rule group that you want to delete. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.init.delete(
                ctx, firewall_rule_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.init.delete firewall_rule_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="delete_firewall_rule_group",
        op_kwargs={"FirewallRuleGroupId": firewall_rule_group_id},
    )


async def disassociate(hub, ctx, firewall_rule_group_association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a FirewallRuleGroup from a VPC, to remove DNS filtering from the VPC.

    Args:
        firewall_rule_group_association_id(str): The identifier of the FirewallRuleGroupAssociation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.init.disassociate(
                ctx, firewall_rule_group_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.init.disassociate firewall_rule_group_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="disassociate_firewall_rule_group",
        op_kwargs={
            "FirewallRuleGroupAssociationId": firewall_rule_group_association_id
        },
    )


async def get(hub, ctx, firewall_rule_group_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified firewall rule group.

    Args:
        firewall_rule_group_id(str): The unique identifier of the firewall rule group. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.init.get(
                ctx, firewall_rule_group_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.init.get firewall_rule_group_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_firewall_rule_group",
        op_kwargs={"FirewallRuleGroupId": firewall_rule_group_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the minimal high-level information for the rule groups that you have defined.  A single call might return only a partial list of the rule groups. For information, see MaxResults.

    Args:
        max_results(int, optional): The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a NextToken value that you can use in a subsequent call to get the next batch of objects. If you don't specify a value for MaxResults, Resolver returns up to 100 objects. . Defaults to None.
        next_token(str, optional): For the first call to this list request, omit this value. When you request a list of objects, Resolver returns at most the number of objects specified in MaxResults. If more objects are available for retrieval, Resolver returns a NextToken value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_firewall_rule_groups",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
