"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, firewall_rule_group_association_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a firewall rule group association, which enables DNS filtering for a VPC with one rule group. A VPC can have more than one firewall rule group association, and a rule group can be associated with more than one VPC.

    Args:
        firewall_rule_group_association_id(str): The identifier of the FirewallRuleGroupAssociation. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.association.get(
                ctx, firewall_rule_group_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.association.get firewall_rule_group_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="get_firewall_rule_group_association",
        op_kwargs={
            "FirewallRuleGroupAssociationId": firewall_rule_group_association_id
        },
    )


async def list_all(
    hub,
    ctx,
    firewall_rule_group_id: str = None,
    vpc_id: str = None,
    priority: int = None,
    status: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.  A single call might return only a partial list of the associations. For information, see MaxResults.

    Args:
        firewall_rule_group_id(str, optional): The unique identifier of the firewall rule group that you want to retrieve the associations for. Leave this blank to retrieve associations for any rule group. . Defaults to None.
        vpc_id(str, optional): The unique identifier of the VPC that you want to retrieve the associations for. Leave this blank to retrieve associations for any VPC. . Defaults to None.
        priority(int, optional): The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting. . Defaults to None.
        status(str, optional): The association Status setting that you want DNS Firewall to filter on for the list. If you don't specify this, then DNS Firewall returns all associations, regardless of status. Defaults to None.
        max_results(int, optional): The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a NextToken value that you can use in a subsequent call to get the next batch of objects. If you don't specify a value for MaxResults, Resolver returns up to 100 objects. . Defaults to None.
        next_token(str, optional): For the first call to this list request, omit this value. When you request a list of objects, Resolver returns at most the number of objects specified in MaxResults. If more objects are available for retrieval, Resolver returns a NextToken value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.association.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.association.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_firewall_rule_group_associations",
        op_kwargs={
            "FirewallRuleGroupId": firewall_rule_group_id,
            "VpcId": vpc_id,
            "Priority": priority,
            "Status": status,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    firewall_rule_group_association_id: str,
    priority: int = None,
    mutation_protection: str = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Changes the association of a FirewallRuleGroup with a VPC. The association enables DNS filtering for the VPC.

    Args:
        firewall_rule_group_association_id(str): The identifier of the FirewallRuleGroupAssociation. .
        priority(int, optional): The setting that determines the processing order of the rule group among the rule groups that you associate with the specified VPC. DNS Firewall filters VPC traffic starting from the rule group with the lowest numeric priority setting.  You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 100, 200, and so on. You can change the priority setting for a rule group association after you create it. Defaults to None.
        mutation_protection(str, optional): If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections. . Defaults to None.
        name(str, optional): The name of the rule group association. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.rule.group.association.update(
                ctx, firewall_rule_group_association_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.rule.group.association.update firewall_rule_group_association_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="update_firewall_rule_group_association",
        op_kwargs={
            "FirewallRuleGroupAssociationId": firewall_rule_group_association_id,
            "Priority": priority,
            "MutationProtection": mutation_protection,
            "Name": name,
        },
    )
