"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def import_(
    hub, ctx, firewall_domain_list_id: str, operation: str, domain_file_url: str
) -> Dict:
    r"""
    **Autogenerated function**

    Imports domain names from a file into a domain list, for use in a DNS firewall rule group.  Each domain specification in your domain list must satisfy the following requirements:    It can optionally start with * (asterisk).   With the exception of the optional starting asterisk, it must only contain the following characters: A-Z, a-z, 0-9, - (hyphen).   It must be from 1-255 characters in length.

    Args:
        firewall_domain_list_id(str): The ID of the domain list that you want to modify with the import operation.
        operation(str): What you want DNS Firewall to do with the domains that are listed in the file. This must be set to REPLACE, which updates the domain list to exactly match the list in the file. .
        domain_file_url(str): The fully qualified URL or URI of the file stored in Amazon Simple Storage Service (Amazon S3) that contains the list of domains to import. The file must be in an S3 bucket that's in the same Region as your DNS Firewall. The file must be a text file and must contain a single domain per line.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.domain.init.import(ctx, firewall_domain_list_id=value, operation=value, domain_file_url=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.domain.init.import firewall_domain_list_id=value, operation=value, domain_file_url=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="import_firewall_domains",
        op_kwargs={
            "FirewallDomainListId": firewall_domain_list_id,
            "Operation": operation,
            "DomainFileUrl": domain_file_url,
        },
    )


async def list_all(
    hub,
    ctx,
    firewall_domain_list_id: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the domains that you have defined for the specified firewall domain list.  A single call might return only a partial list of the domains. For information, see MaxResults.

    Args:
        firewall_domain_list_id(str): The ID of the domain list whose domains you want to retrieve. .
        max_results(int, optional): The maximum number of objects that you want Resolver to return for this request. If more objects are available, in the response, Resolver provides a NextToken value that you can use in a subsequent call to get the next batch of objects. If you don't specify a value for MaxResults, Resolver returns up to 100 objects. . Defaults to None.
        next_token(str, optional): For the first call to this list request, omit this value. When you request a list of objects, Resolver returns at most the number of objects specified in MaxResults. If more objects are available for retrieval, Resolver returns a NextToken value in the response. To retrieve the next batch of objects, use the token that was returned for the prior request in your next request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.domain.init.list_all(ctx, firewall_domain_list_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.domain.init.list_all firewall_domain_list_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="list_firewall_domains",
        op_kwargs={
            "FirewallDomainListId": firewall_domain_list_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update_multiple(
    hub, ctx, firewall_domain_list_id: str, operation: str, domains: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the firewall domain list from an array of domain specifications.

    Args:
        firewall_domain_list_id(str): The ID of the domain list whose domains you want to update. .
        operation(str): What you want DNS Firewall to do with the domains that you are providing:     ADD - Add the domains to the ones that are already in the domain list.     REMOVE - Search the domain list for the domains and remove them from the list.    REPLACE - Update the domain list to exactly match the list that you are providing.   .
        domains(List): A list of domains to use in the update operation. Each domain specification in your domain list must satisfy the following requirements:    It can optionally start with * (asterisk).   With the exception of the optional starting asterisk, it must only contain the following characters: A-Z, a-z, 0-9, - (hyphen).   It must be from 1-255 characters in length.   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53resolver.firewall.domain.init.update_multiple(ctx, firewall_domain_list_id=value, operation=value, domains=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53resolver.firewall.domain.init.update_multiple firewall_domain_list_id=value, operation=value, domains=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53resolver",
        operation="update_firewall_domains",
        op_kwargs={
            "FirewallDomainListId": firewall_domain_list_id,
            "Operation": operation,
            "Domains": domains,
        },
    )
