"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def delete(hub, ctx, domain_name: str, tags_to_delete: List) -> Dict:
    r"""
    **Autogenerated function**

    This operation deletes the specified tags for a domain. All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.

    Args:
        domain_name(str): The domain for which you want to delete one or more tags.
        tags_to_delete(List): A list of tag keys to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.tags_for_domain.delete(
                ctx, domain_name=value, tags_to_delete=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.tags_for_domain.delete domain_name=value, tags_to_delete=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="delete_tags_for_domain",
        op_kwargs={"DomainName": domain_name, "TagsToDelete": tags_to_delete},
    )


async def list_(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns all of the tags that are associated with the specified domain. All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.

    Args:
        domain_name(str): The domain for which you want to get a list of tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.tags_for_domain.list(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.tags_for_domain.list domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="list_tags_for_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def update(hub, ctx, domain_name: str, tags_to_update: List = None) -> Dict:
    r"""
    **Autogenerated function**

    This operation adds or updates tags for a specified domain. All tag operations are eventually consistent; subsequent operations might not immediately represent all issued operations.

    Args:
        domain_name(str): The domain for which you want to add or update tags.
        tags_to_update(List, optional): A list of the tag keys and values that you want to add or update. If you specify a key that already exists, the corresponding value will be replaced. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.tags_for_domain.update(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.tags_for_domain.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="update_tags_for_domain",
        op_kwargs={"DomainName": domain_name, "TagsToUpdate": tags_to_update},
    )
