"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, submitted_since: str = None, marker: str = None, max_items: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about all of the operations that return an operation ID and that have ever been performed on domains that were registered by the current account.

    Args:
        submitted_since(str, optional): An optional parameter that lets you get information about all the operations that you submitted after a specified date and time. Specify the date and time in Unix time format and Coordinated Universal time (UTC). Defaults to None.
        marker(str, optional): For an initial request for a list of operations, omit this element. If the number of operations that are not yet complete is greater than the value that you specified for MaxItems, you can use Marker to return additional operations. Get the value of NextPageMarker from the previous response, and submit another request that includes the value of NextPageMarker in the Marker element. Defaults to None.
        max_items(int, optional): Number of domains to be returned. Default: 20. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.operation.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.operation.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="list_operations",
        op_kwargs={
            "SubmittedSince": submitted_since,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
