"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, operation_id: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns the current status of an operation that is not completed.

    Args:
        operation_id(str): The identifier for the operation for which you want to get the status. Route 53 returned the identifier in the response to the original request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.operation.detail.get(ctx, operation_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.operation.detail.get operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="get_operation_detail",
        op_kwargs={"OperationId": operation_id},
    )
