"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation removes the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers. We recommend you refrain from performing this action unless you intend to transfer the domain to a different registrar. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.

    Args:
        domain_name(str): The name of the domain that you want to remove the transfer lock for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.transfer.lock.disable(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.transfer.lock.disable domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="disable_domain_transfer_lock",
        op_kwargs={"DomainName": domain_name},
    )


async def enable(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation sets the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers. Successful submission returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.

    Args:
        domain_name(str): The name of the domain that you want to set the transfer lock for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.transfer.lock.enable(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.transfer.lock.enable domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="enable_domain_transfer_lock",
        op_kwargs={"DomainName": domain_name},
    )
