"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(hub, ctx, domain_name: str, password: str) -> Dict:
    r"""
    **Autogenerated function**

    Accepts the transfer of a domain from another AWS account to the current AWS account. You initiate a transfer between AWS accounts using TransferDomainToAnotherAwsAccount.  Use either ListOperations or GetOperationDetail to determine whether the operation succeeded. GetOperationDetail provides additional information, for example, Domain Transfer from Aws Account 111122223333 has been cancelled.

    Args:
        domain_name(str): The name of the domain that was specified when another AWS account submitted a TransferDomainToAnotherAwsAccount request. .
        password(str): The password that was returned by the TransferDomainToAnotherAwsAccount request. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.transfer.from_another_aws_account.accept(
                ctx, domain_name=value, password=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.transfer.from_another_aws_account.accept domain_name=value, password=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="accept_domain_transfer_from_another_aws_account",
        op_kwargs={"DomainName": domain_name, "Password": password},
    )


async def reject(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Rejects the transfer of a domain from another AWS account to the current AWS account. You initiate a transfer between AWS accounts using TransferDomainToAnotherAwsAccount.  Use either ListOperations or GetOperationDetail to determine whether the operation succeeded. GetOperationDetail provides additional information, for example, Domain Transfer from Aws Account 111122223333 has been cancelled.

    Args:
        domain_name(str): The name of the domain that was specified when another AWS account submitted a TransferDomainToAnotherAwsAccount request. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.transfer.from_another_aws_account.reject(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.transfer.from_another_aws_account.reject domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="reject_domain_transfer_from_another_aws_account",
        op_kwargs={"DomainName": domain_name},
    )
