"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(
    hub, ctx, domain_name: str, suggestion_count: int, only_available: bool
) -> Dict:
    r"""
    **Autogenerated function**

    The GetDomainSuggestions operation returns a list of suggested domain names.

    Args:
        domain_name(str): A domain name that you want to use as the basis for a list of possible domain names. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see Domains that You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. The domain name can contain only the following characters:   Letters a through z. Domain names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You can't specify a hyphen at the beginning or end of a label.    Period (.) to separate the labels in the name, such as the . in example.com.   Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see Domains that You Can Register with Amazon Route 53. .
        suggestion_count(int): The number of suggested domain names that you want Route 53 to return. Specify a value between 1 and 50.
        only_available(bool): If OnlyAvailable is true, Route 53 returns only domain names that are available. If OnlyAvailable is false, Route 53 returns domain names without checking whether they're available to be registered. To determine whether the domain is available, you can call checkDomainAvailability for each suggestion.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.suggestion.get_all(
                ctx, domain_name=value, suggestion_count=value, only_available=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.suggestion.get_all domain_name=value, suggestion_count=value, only_available=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="get_domain_suggestions",
        op_kwargs={
            "DomainName": domain_name,
            "SuggestionCount": suggestion_count,
            "OnlyAvailable": only_available,
        },
    )
