"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update_multiple(
    hub, ctx, domain_name: str, nameservers: List, fi_auth_key: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation replaces the current set of name servers for the domain with the specified set of name servers. If you use Amazon Route 53 as your DNS service, specify the four name servers in the delegation set for the hosted zone for the domain. If successful, this operation returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.

    Args:
        domain_name(str): The name of the domain that you want to change name servers for.
        fi_auth_key(str, optional): The authorization key for .fi domains. Defaults to None.
        nameservers(List): A list of new name servers for the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.nameserver.update_multiple(
                ctx, domain_name=value, nameservers=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.nameserver.update_multiple domain_name=value, nameservers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="update_domain_nameservers",
        op_kwargs={
            "DomainName": domain_name,
            "FIAuthKey": fi_auth_key,
            "Nameservers": nameservers,
        },
    )
