"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(hub, ctx, marker: str = None, max_items: int = None) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns all the domain names registered with Amazon Route 53 for the current AWS account.

    Args:
        marker(str, optional): For an initial request for a list of domains, omit this element. If the number of domains that are associated with the current AWS account is greater than the value that you specified for MaxItems, you can use Marker to return additional domains. Get the value of NextPageMarker from the previous response, and submit another request that includes the value of NextPageMarker in the Marker element. Constraints: The marker must match the value specified in the previous request. Defaults to None.
        max_items(int, optional): Number of domains to be returned. Default: 20. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="list_domains",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def register(
    hub,
    ctx,
    domain_name: str,
    duration_in_years: int,
    admin_contact: Dict,
    registrant_contact: Dict,
    tech_contact: Dict,
    idn_lang_code: str = None,
    auto_renew: bool = None,
    privacy_protect_admin_contact: bool = None,
    privacy_protect_registrant_contact: bool = None,
    privacy_protect_tech_contact: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation registers a domain. Domains are registered either by Amazon Registrar (for .com, .net, and .org domains) or by our registrar associate, Gandi (for all other domains). For some top-level domains (TLDs), this operation requires extra parameters. When you register a domain, Amazon Route 53 does the following:   Creates a Route 53 hosted zone that has the same name as the domain. Route 53 assigns four name servers to your hosted zone and automatically updates your domain registration with the names of these name servers.   Enables autorenew, so your domain registration will renew automatically each year. We'll notify you in advance of the renewal date so you can choose whether to renew the registration.   Optionally enables privacy protection, so WHOIS queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you don't enable privacy protection, WHOIS queries return the information that you entered for the registrant, admin, and tech contacts.   If registration is successful, returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant is notified by email.   Charges your AWS account an amount based on the top-level domain. For more information, see Amazon Route 53 Pricing.

    Args:
        domain_name(str): The domain name that you want to register. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see Domains that You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. The domain name can contain only the following characters:   Letters a through z. Domain names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You can't specify a hyphen at the beginning or end of a label.    Period (.) to separate the labels in the name, such as the . in example.com.   Internationalized domain names are not supported for some top-level domains. To determine whether the TLD that you want to use supports internationalized domain names, see Domains that You Can Register with Amazon Route 53. For more information, see Formatting Internationalized Domain Names. .
        idn_lang_code(str, optional): Reserved for future use. Defaults to None.
        duration_in_years(int): The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. For the range of valid values for your domain, see Domains that You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. Default: 1.
        auto_renew(bool, optional): Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged. Default: true . Defaults to None.
        admin_contact(Dict): Provides detailed contact information. For information about the values that you specify for each element, see ContactDetail.
        registrant_contact(Dict): Provides detailed contact information. For information about the values that you specify for each element, see ContactDetail.
        tech_contact(Dict): Provides detailed contact information. For information about the values that you specify for each element, see ContactDetail.
        privacy_protect_admin_contact(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the admin contact. Default: true . Defaults to None.
        privacy_protect_registrant_contact(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the registrant contact (the domain owner). Default: true . Defaults to None.
        privacy_protect_tech_contact(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the technical contact. Default: true . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.init.register(
                ctx,
                domain_name=value,
                duration_in_years=value,
                admin_contact=value,
                registrant_contact=value,
                tech_contact=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.init.register domain_name=value, duration_in_years=value, admin_contact=value, registrant_contact=value, tech_contact=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="register_domain",
        op_kwargs={
            "DomainName": domain_name,
            "IdnLangCode": idn_lang_code,
            "DurationInYears": duration_in_years,
            "AutoRenew": auto_renew,
            "AdminContact": admin_contact,
            "RegistrantContact": registrant_contact,
            "TechContact": tech_contact,
            "PrivacyProtectAdminContact": privacy_protect_admin_contact,
            "PrivacyProtectRegistrantContact": privacy_protect_registrant_contact,
            "PrivacyProtectTechContact": privacy_protect_tech_contact,
        },
    )


async def renew(
    hub, ctx, domain_name: str, current_expiry_year: int, duration_in_years: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    This operation renews a domain for the specified number of years. The cost of renewing your domain is billed to your AWS account. We recommend that you renew your domain several weeks before the expiration date. Some TLD registries delete domains before the expiration date if you haven't renewed far enough in advance. For more information about renewing domain registration, see Renewing Registration for a Domain in the Amazon Route 53 Developer Guide.

    Args:
        domain_name(str): The name of the domain that you want to renew.
        duration_in_years(int, optional): The number of years that you want to renew the domain for. The maximum number of years depends on the top-level domain. For the range of valid values for your domain, see Domains that You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. Default: 1. Defaults to None.
        current_expiry_year(int): The year when the registration for the domain is set to expire. This value must match the current expiration date for the domain.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.init.renew(
                ctx, domain_name=value, current_expiry_year=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.init.renew domain_name=value, current_expiry_year=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="renew_domain",
        op_kwargs={
            "DomainName": domain_name,
            "DurationInYears": duration_in_years,
            "CurrentExpiryYear": current_expiry_year,
        },
    )


async def transfer(
    hub,
    ctx,
    domain_name: str,
    duration_in_years: int,
    admin_contact: Dict,
    registrant_contact: Dict,
    tech_contact: Dict,
    idn_lang_code: str = None,
    nameservers: List = None,
    auth_code: str = None,
    auto_renew: bool = None,
    privacy_protect_admin_contact: bool = None,
    privacy_protect_registrant_contact: bool = None,
    privacy_protect_tech_contact: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Transfers a domain from another registrar to Amazon Route 53. When the transfer is complete, the domain is registered either with Amazon Registrar (for .com, .net, and .org domains) or with our registrar associate, Gandi (for all other TLDs). For more information about transferring domains, see the following topics:   For transfer requirements, a detailed procedure, and information about viewing the status of a domain that you're transferring to Route 53, see Transferring Registration for a Domain to Amazon Route 53 in the Amazon Route 53 Developer Guide.   For information about how to transfer a domain from one AWS account to another, see TransferDomainToAnotherAwsAccount.    For information about how to transfer a domain to another domain registrar, see Transferring a Domain from Amazon Route 53 to Another Registrar in the Amazon Route 53 Developer Guide.   If the registrar for your domain is also the DNS service provider for the domain, we highly recommend that you transfer your DNS service to Route 53 or to another DNS service provider before you transfer your registration. Some registrars provide free DNS service when you purchase a domain registration. When you transfer the registration, the previous registrar will not renew your domain registration and could end your DNS service at any time.  If the registrar for your domain is also the DNS service provider for the domain and you don't transfer DNS service to another provider, your website, email, and the web applications associated with the domain might become unavailable.  If the transfer is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the transfer doesn't complete successfully, the domain registrant will be notified by email.

    Args:
        domain_name(str): The name of the domain that you want to transfer to Route 53. The top-level domain (TLD), such as .com, must be a TLD that Route 53 supports. For a list of supported TLDs, see Domains that You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. The domain name can contain only the following characters:   Letters a through z. Domain names are not case sensitive.   Numbers 0 through 9.   Hyphen (-). You can't specify a hyphen at the beginning or end of a label.    Period (.) to separate the labels in the name, such as the . in example.com.  .
        idn_lang_code(str, optional): Reserved for future use. Defaults to None.
        duration_in_years(int): The number of years that you want to register the domain for. Domains are registered for a minimum of one year. The maximum period depends on the top-level domain. Default: 1.
        nameservers(List, optional): Contains details for the host and glue IP addresses. Defaults to None.
        auth_code(str, optional): The authorization code for the domain. You get this value from the current registrar. Defaults to None.
        auto_renew(bool, optional): Indicates whether the domain will be automatically renewed (true) or not (false). Autorenewal only takes effect after the account is charged. Default: true. Defaults to None.
        admin_contact(Dict): Provides detailed contact information.
        registrant_contact(Dict): Provides detailed contact information.
        tech_contact(Dict): Provides detailed contact information.
        privacy_protect_admin_contact(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the admin contact. Default: true . Defaults to None.
        privacy_protect_registrant_contact(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the registrant contact (domain owner). Default: true . Defaults to None.
        privacy_protect_tech_contact(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the technical contact. Default: true . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.init.transfer(
                ctx,
                domain_name=value,
                duration_in_years=value,
                admin_contact=value,
                registrant_contact=value,
                tech_contact=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.init.transfer domain_name=value, duration_in_years=value, admin_contact=value, registrant_contact=value, tech_contact=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="transfer_domain",
        op_kwargs={
            "DomainName": domain_name,
            "IdnLangCode": idn_lang_code,
            "DurationInYears": duration_in_years,
            "Nameservers": nameservers,
            "AuthCode": auth_code,
            "AutoRenew": auto_renew,
            "AdminContact": admin_contact,
            "RegistrantContact": registrant_contact,
            "TechContact": tech_contact,
            "PrivacyProtectAdminContact": privacy_protect_admin_contact,
            "PrivacyProtectRegistrantContact": privacy_protect_registrant_contact,
            "PrivacyProtectTechContact": privacy_protect_tech_contact,
        },
    )
