"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    domain_name: str,
    admin_privacy: bool = None,
    registrant_privacy: bool = None,
    tech_privacy: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation updates the specified domain contact's privacy setting. When privacy protection is enabled, contact information such as email address is replaced either with contact information for Amazon Registrar (for .com, .net, and .org domains) or with contact information for our registrar associate, Gandi. This operation affects only the contact information for the specified contact type (registrant, administrator, or tech). If the request succeeds, Amazon Route 53 returns an operation ID that you can use with GetOperationDetail to track the progress and completion of the action. If the request doesn't complete successfully, the domain registrant will be notified by email.  By disabling the privacy service via API, you consent to the publication of the contact information provided for this domain via the public WHOIS database. You certify that you are the registrant of this domain name and have the authority to make this decision. You may withdraw your consent at any time by enabling privacy protection using either UpdateDomainContactPrivacy or the Route 53 console. Enabling privacy protection removes the contact information provided for this domain from the WHOIS database. For more information on our privacy practices, see https://aws.amazon.com/privacy/.

    Args:
        domain_name(str): The name of the domain that you want to update the privacy setting for.
        admin_privacy(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the admin contact. Defaults to None.
        registrant_privacy(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the registrant contact (domain owner). Defaults to None.
        tech_privacy(bool, optional): Whether you want to conceal contact information from WHOIS queries. If you specify true, WHOIS ("who is") queries return contact information either for Amazon Registrar (for .com, .net, and .org domains) or for our registrar associate, Gandi (for all other TLDs). If you specify false, WHOIS queries return the information that you entered for the technical contact. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.contact.privacy.update(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.contact.privacy.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="update_domain_contact_privacy",
        op_kwargs={
            "DomainName": domain_name,
            "AdminPrivacy": admin_privacy,
            "RegistrantPrivacy": registrant_privacy,
            "TechPrivacy": tech_privacy,
        },
    )
