"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub,
    ctx,
    domain_name: str,
    admin_contact: Dict = None,
    registrant_contact: Dict = None,
    tech_contact: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation updates the contact information for a particular domain. You must specify information for at least one contact: registrant, administrator, or technical. If the update is successful, this method returns an operation ID that you can use to track the progress and completion of the action. If the request is not completed successfully, the domain registrant will be notified by email.

    Args:
        domain_name(str): The name of the domain that you want to update contact information for.
        admin_contact(Dict, optional): Provides detailed contact information. Defaults to None.
        registrant_contact(Dict, optional): Provides detailed contact information. Defaults to None.
        tech_contact(Dict, optional): Provides detailed contact information. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.contact.init.update(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.contact.init.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="update_domain_contact",
        op_kwargs={
            "DomainName": domain_name,
            "AdminContact": admin_contact,
            "RegistrantContact": registrant_contact,
            "TechContact": tech_contact,
        },
    )
