"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation disables automatic renewal of domain registration for the specified domain.

    Args:
        domain_name(str): The name of the domain that you want to disable automatic renewal for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.auto_renew.disable(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.auto_renew.disable domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="disable_domain_auto_renew",
        op_kwargs={"DomainName": domain_name},
    )


async def enable(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation configures Amazon Route 53 to automatically renew the specified domain before the domain registration expires. The cost of renewing your domain registration is billed to your AWS account. The period during which you can renew a domain name varies by TLD. For a list of TLDs and their renewal policies, see Domains That You Can Register with Amazon Route 53 in the Amazon Route 53 Developer Guide. Route 53 requires that you renew before the end of the renewal period so we can complete processing before the deadline.

    Args:
        domain_name(str): The name of the domain that you want to enable automatic renewal for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.auto_renew.enable(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.auto_renew.enable domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="enable_domain_auto_renew",
        op_kwargs={"DomainName": domain_name},
    )
