"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def retrieve(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    This operation returns the AuthCode for the domain. To transfer a domain to another registrar, you provide this value to the new registrar.

    Args:
        domain_name(str): The name of the domain that you want to get an authorization code for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.domain.auth_code.retrieve(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.domain.auth_code.retrieve domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="retrieve_domain_auth_code",
        op_kwargs={"DomainName": domain_name},
    )
