"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, domain_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation returns information about whether the registrant contact has responded. If you want us to resend the email, use the ResendContactReachabilityEmail operation.

    Args:
        domain_name(str, optional): The name of the domain for which you want to know whether the registrant contact has confirmed that the email address is valid. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.contact_reachability.status.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.contact_reachability.status.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="get_contact_reachability_status",
        op_kwargs={"domainName": domain_name},
    )
