"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def resend(hub, ctx, domain_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, this operation resends the confirmation email to the current email address for the registrant contact.

    Args:
        domain_name(str, optional): The name of the domain for which you want Route 53 to resend a confirmation email to the registrant contact. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.contact_reachability.email.resend(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.contact_reachability.email.resend
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="resend_contact_reachability_email",
        op_kwargs={"domainName": domain_name},
    )
