"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def view(
    hub,
    ctx,
    start: str = None,
    end: str = None,
    marker: str = None,
    max_items: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns all the domain-related billing records for the current AWS account for a specified period

    Args:
        start(str, optional): The beginning date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC). Defaults to None.
        end(str, optional): The end date and time for the time period for which you want a list of billing records. Specify the date and time in Unix time format and Coordinated Universal time (UTC). Defaults to None.
        marker(str, optional): For an initial request for a list of billing records, omit this element. If the number of billing records that are associated with the current AWS account during the specified period is greater than the value that you specified for MaxItems, you can use Marker to return additional billing records. Get the value of NextPageMarker from the previous response, and submit another request that includes the value of NextPageMarker in the Marker element.  Constraints: The marker must match the value of NextPageMarker that was returned in the previous response. Defaults to None.
        max_items(int, optional): The number of billing records to be returned. Default: 20. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53domain.billing.view(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53domain.billing.view
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53domains",
        operation="view_billing",
        op_kwargs={"Start": start, "End": end, "Marker": marker, "MaxItems": max_items},
    )
