"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, resource_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the tags assigned to the specified resource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.tags_for_resource.list_all(
                ctx, resource_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.tags_for_resource.list_all resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="list_tags_for_resources",
        op_kwargs={"ResourceArn": resource_arn},
    )
