"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, max_results: int = None, next_token: str = None, resource_type: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of rules that are applied as part of Readiness Checks.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.
        resource_type(str, optional): Filter parameter which specifies the rules to return given a resource type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.rule.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.rule.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="list_rules",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ResourceType": resource_type,
        },
    )
