"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "set"


async def create(
    hub,
    ctx,
    resource_set_name: str,
    resource_set_type: str,
    resources: List,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Resource Set.

    Args:
        resource_set_name(str): The name of the ResourceSet to create.
        resource_set_type(str): AWS Resource type of the resources in the ResourceSet.
        resources(List): A list of Resource objects.
        tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.set_.create(
                ctx, resource_set_name=value, resource_set_type=value, resources=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.set.create resource_set_name=value, resource_set_type=value, resources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="create_resource_set",
        op_kwargs={
            "ResourceSetName": resource_set_name,
            "ResourceSetType": resource_set_type,
            "Resources": resources,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, resource_set_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Resource Set.

    Args:
        resource_set_name(str): The ResourceSet to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.set_.delete(
                ctx, resource_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.set.delete resource_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="delete_resource_set",
        op_kwargs={"ResourceSetName": resource_set_name},
    )


async def get(hub, ctx, resource_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a Resource Set.

    Args:
        resource_set_name(str): The ResourceSet to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.set_.get(
                ctx, resource_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.set.get resource_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_resource_set",
        op_kwargs={"ResourceSetName": resource_set_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of Resource Sets.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.set_.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.set.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="list_resource_sets",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, resource_set_name: str, resource_set_type: str, resources: List
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Resource Set.

    Args:
        resource_set_name(str): The ResourceSet to update.
        resource_set_type(str): AWS Resource Type of the resources in the ResourceSet.
        resources(List): A list of Resource objects.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.set_.update(
                ctx, resource_set_name=value, resource_set_type=value, resources=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.set.update resource_set_name=value, resource_set_type=value, resources=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="update_resource_set",
        op_kwargs={
            "ResourceSetName": resource_set_name,
            "ResourceSetType": resource_set_type,
            "Resources": resources,
        },
    )
