"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Adds tags to the specified resource. You can specify one or more tags to add.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        tags(Dict): A collection of tags associated with a resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.init.tag(
                ctx, resource_arn=value, tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.init.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="tag_resource",
        op_kwargs={"ResourceArn": resource_arn, "Tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes tags from the specified resource. You can specify one or more tags to remove.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) for the resource. You can get this from the response to any request to the resource.
        tag_keys(List): A comma-separated list of the tag keys to remove from the resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.resource.init.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.resource.init.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="untag_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeys": tag_keys},
    )
