"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, recovery_group_name: str, max_results: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a Recovery Group.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.
        recovery_group_name(str): The name of the RecoveryGroup.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.recovery_group.readiness_summary.get(
                ctx, recovery_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.recovery_group.readiness_summary.get recovery_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_recovery_group_readiness_summary",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "RecoveryGroupName": recovery_group_name,
        },
    )
