"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, recovery_group_name: str, cells: List = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Recovery Group.

    Args:
        cells(List, optional): A list of Cell arns. Defaults to None.
        recovery_group_name(str): The name of the RecoveryGroup to create.
        tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.recovery_group.init.create(
                ctx, recovery_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.recovery_group.init.create recovery_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="create_recovery_group",
        op_kwargs={
            "Cells": cells,
            "RecoveryGroupName": recovery_group_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, recovery_group_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Recovery Group.

    Args:
        recovery_group_name(str): The RecoveryGroup to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.recovery_group.init.delete(
                ctx, recovery_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.recovery_group.init.delete recovery_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="delete_recovery_group",
        op_kwargs={"RecoveryGroupName": recovery_group_name},
    )


async def get(hub, ctx, recovery_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a Recovery Group.

    Args:
        recovery_group_name(str): The RecoveryGroup to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.recovery_group.init.get(
                ctx, recovery_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.recovery_group.init.get recovery_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_recovery_group",
        op_kwargs={"RecoveryGroupName": recovery_group_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of Recovery Groups.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.recovery_group.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.recovery_group.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="list_recovery_groups",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, cells: List, recovery_group_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Recovery Group.

    Args:
        cells(List): A list of Cell arns, completely replaces previous list.
        recovery_group_name(str): The RecoveryGroup to update.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.recovery_group.init.update(
                ctx, cells=value, recovery_group_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.recovery_group.init.update cells=value, recovery_group_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="update_recovery_group",
        op_kwargs={"Cells": cells, "RecoveryGroupName": recovery_group_name},
    )
