"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    readiness_check_name: str,
    resource_identifier: str,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about the status of an individual resource within a Readiness Check's Resource Set.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.
        readiness_check_name(str): The ReadinessCheck to get.
        resource_identifier(str): The resource ARN or component Id to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.readiness_check.resource_status.get(
                ctx, readiness_check_name=value, resource_identifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.readiness_check.resource_status.get readiness_check_name=value, resource_identifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_readiness_check_resource_status",
        op_kwargs={
            "MaxResults": max_results,
            "NextToken": next_token,
            "ReadinessCheckName": readiness_check_name,
            "ResourceIdentifier": resource_identifier,
        },
    )
