"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, readiness_check_name: str, resource_set_name: str, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Readiness Check.

    Args:
        readiness_check_name(str): The name of the ReadinessCheck to create.
        resource_set_name(str): The name of the ResourceSet to check.
        tags(Dict, optional): A collection of tags associated with a resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.readiness_check.init.create(
                ctx, readiness_check_name=value, resource_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.readiness_check.init.create readiness_check_name=value, resource_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="create_readiness_check",
        op_kwargs={
            "ReadinessCheckName": readiness_check_name,
            "ResourceSetName": resource_set_name,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, readiness_check_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Readiness Check.

    Args:
        readiness_check_name(str): The ReadinessCheck to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.readiness_check.init.delete(
                ctx, readiness_check_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.readiness_check.init.delete readiness_check_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="delete_readiness_check",
        op_kwargs={"ReadinessCheckName": readiness_check_name},
    )


async def get(hub, ctx, readiness_check_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a ReadinessCheck.

    Args:
        readiness_check_name(str): The ReadinessCheck to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.readiness_check.init.get(
                ctx, readiness_check_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.readiness_check.init.get readiness_check_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="get_readiness_check",
        op_kwargs={"ReadinessCheckName": readiness_check_name},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of Readiness Checks.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.readiness_check.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.readiness_check.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="list_readiness_checks",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(hub, ctx, readiness_check_name: str, resource_set_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates an exisiting Readiness Check.

    Args:
        readiness_check_name(str): The ReadinessCheck to update.
        resource_set_name(str): The name of the ResourceSet to check.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.readiness_check.init.update(
                ctx, readiness_check_name=value, resource_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.readiness_check.init.update readiness_check_name=value, resource_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="update_readiness_check",
        op_kwargs={
            "ReadinessCheckName": readiness_check_name,
            "ResourceSetName": resource_set_name,
        },
    )
