"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, cross_account_authorization: str) -> Dict:
    r"""
    **Autogenerated function**

    Create a new cross account readiness authorization.

    Args:
        cross_account_authorization(str): The cross account authorization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.cross_account_authorization.create(
                ctx, cross_account_authorization=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.cross_account_authorization.create cross_account_authorization=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="create_cross_account_authorization",
        op_kwargs={"CrossAccountAuthorization": cross_account_authorization},
    )


async def delete(hub, ctx, cross_account_authorization: str) -> Dict:
    r"""
    **Autogenerated function**

    Delete cross account readiness authorization

    Args:
        cross_account_authorization(str): The cross account authorization.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.cross_account_authorization.delete(
                ctx, cross_account_authorization=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.cross_account_authorization.delete cross_account_authorization=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="delete_cross_account_authorization",
        op_kwargs={"CrossAccountAuthorization": cross_account_authorization},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a collection of cross account readiness authorizations.

    Args:
        max_results(int, optional): Upper bound on number of records to return. Defaults to None.
        next_token(str, optional): A token used to resume pagination from the end of a previous request. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.route53_recovery_readiness.cross_account_authorization.list_all(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.route53_recovery_readiness.cross_account_authorization.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="route53-recovery-readiness",
        operation="list_cross_account_authorizations",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
